#!/bin/bash
#
#  aeMonitor V4 for CentOS6 Installation script 
#  Ver 1.0
#  Date 2016.09.21
#  Auther: Shinji Hirose @ Praesentia
#  (c) 2016 Praesentia Corp. All rights reserved 

WDIR=`pwd`
HN=`hostname`
LOG=/var/tmp/aeMonitor-install-`date +%Y%m%d`.log

echo "##### Checking instration environment #####"
echo "#"
echo "# -- Check required packages  "
echo "#"
EFLG=0

#yum list installed |grep wget.x86_64 > /dev/null
#if [ $? == 1 ]; then
#EFLG=1
#echo "   'wget' package is required. Please use 'yum install wget' command."
#fi

yum list installed |grep gd.x86_64 > /dev/null
if [ $? == 1 ]; then
EFLG=1
echo "   'gd' package is required. Please use 'yum install gd' command."
fi

#yum list installed |grep gd-devel.x86_64 > /dev/null
#if [ $? == 1 ]; then
#EFLG=1
#echo "   'gd-devel' package is required. Please use 'yum install gd-devel' command."
#fi

yum list installed |grep net-snmp-utils.x86_64 > /dev/null
if [ $? == 1 ]; then
EFLG=1
echo "   'net-snmp-utils' package is required. Please use 'yum install net-snmp-utils' command."
fi

#yum list installed |grep unzip.x86_64 > /dev/null
#if [ $? == 1 ]; then
#EFLG=1
#echo "   'unzip' package is required. Please use 'yum install unzip' command."
#fi

#yum list installed |grep psmisc.x86_64 > /dev/null
#if [ $? == 1 ]; then
#EFLG=1
#echo "   'psmisc' package is required. Please use 'yum install psmisc' command."
#fi

#yum list installed |grep cairo-devel.x86_64 > /dev/null
#if [ $? == 1 ]; then
#EFLG=1
#echo "   'cairo-devel' package is required. Please use 'yum install cairo-devel' command."
#fi

yum list installed |grep pango-devel.x86_64 > /dev/null
if [ $? == 1 ]; then
EFLG=1
echo "   'pango-devel' package is required. Please use 'yum install pango-devel' command."
fi

#yum list installed |grep libpng12.x86_64 > /dev/null
#if [ $? == 1 ]; then
#EFLG=1
#echo "   'libpng12' package is required. Please use 'yum install libpng12' command."
#fi

yum list installed |grep mailx.x86_64 > /dev/null
if [ $? == 1 ]; then
EFLG=1
echo "   'mailx' package is required. Please use 'yum install mailx' command."
fi

if [ $EFLG == 0 ]; then
 echo "   Required package check : OK"
else
 echo "#*********************************#"
 echo " Please install required packages."
 echo "#*********************************#"
 exit 1
fi

echo "#"
echo "# -- Check settings "
echo "#"
SL=`getenforce`

if [ $SL = "Disabled" ]
then
  echo "   SELINUX check : OK"
  echo "#"
else
  echo "   There is a problem in instalation environment: SELINUX is settine as $SL. Instration aborted."
  echo "   Use 'vi /etc/sysconfig/selinux' command and edit, as follows :"
  echo "     SELINUX=disabled"
  echo "   Then, save the file and reboot the system."
  exit 1
fi

grep $HN /etc/sysconfig/network > /dev/null
if [ $? = 1 ]; then
   echo "    There is a problem in /etc/sysconfig/network file. Please add hostname. "
   echo "    Instalation aborted. "
   exit 1
else
     echo "   sysconfig check : OK"
fi
echo "#"

grep $HN /etc/hosts > /dev/null
if [ $? = 1 ]; then
   echo "   The hostname and IP address setting is absent in /etc/hosts. Please add. "
  exit 1
fi
  echo "   /etc/hosts check：OK"

echo "#"  
echo "##### Preparing the instration #####"
echo "#"

tar -xf data >/dev/null 2>&1

########
#
#### Add group & user
#
echo "#"
echo "##### Add users and groups #####"
getent group | grep mysql > /dev/null
if [ $? -ne 0 ] ; then
groupadd mysql
fi
getent group | grep nagios > /dev/null
if [ $? -ne 0 ] ; then
groupadd nagios
fi
getent passwd | grep mysql > /dev/null
if [ $? -ne 0 ] ; then
useradd -g mysql mysql
fi
getent passwd | grep nagios > /dev/null
if [ $? -ne 0 ] ; then
useradd -g nagios nagios
fi

#### extract aeMonitor files 
#
echo "#"
echo "##### Extracting aeMonitor package #####"
#cp aemonitor-gwm.tar /usr/local/.
#cd /usr/local
tar -Pzxf aemonitor-v4.tar.gz

#rm aemonitor-gwm.tar

#
#rm /usr/local/aemonitor/nagios/var/*.log
#rm /usr/local/aemonitor/nagios/var/*.sav
#rm /usr/local/aemonitor/nagios/var/*.tmp
#rm /usr/local/aemonitor/nagios/var/*.lock
#rm /usr/local/aemonitor/nagios/var/objects.cache

#### make rc files 
#
echo "#"
echo "##### Configure start-up environment #####"
echo "#!/bin/sh" > /etc/rc.d/init.d/aemonitor
echo "#" >> /etc/rc.d/init.d/aemonitor
echo "#" >> /etc/rc.d/init.d/aemonitor
echo "# aeMonitor start/shutdown script" >> /etc/rc.d/init.d/aemonitor
echo "#" >> /etc/rc.d/init.d/aemonitor
echo "exec /usr/local/aemonitor/ctlscript.sh \"\$@\"" >> /etc/rc.d/init.d/aemonitor

chmod 755 /etc/rc.d/init.d/aemonitor

cd /etc/rc0.d
ln -s ../init.d/aemonitor K30aemonitor
cd /etc/rc1.d
ln -s ../init.d/aemonitor K30aemonitor
cd /etc/rc6.d
ln -s ../init.d/aemonitor K30aemonitor

cd /etc/rc.d/rc2.d  
ln -s ../init.d/aemonitor S80aemonitor
cd /etc/rc.d/rc3.d  
ln -s ../init.d/aemonitor S80aemonitor
cd /etc/rc.d/rc4.d  
ln -s ../init.d/aemonitor S80aemonitor
cd /etc/rc.d/rc5.d  
ln -s ../init.d/aemonitor S80aemonitor

#### Changing IPtable 

echo "#"
echo "##### IP Table setting：Open #80 port #####"

ACCPORT1="-A INPUT -p tcp -m state --state NEW -m tcp --dport 80 -j ACCEPT"

grep "^[^#].*dport 80" /etc/sysconfig/iptables > /dev/null

if [ $? -eq 1 ]; then
  sed -i -e "10i $ACCPORT1" /etc/sysconfig/iptables
fi

/etc/init.d/iptables restart >>$LOG 2>&1

#### Edit httpd.conf :  add ServerName
#
grep "^\s*ServerName 127.0.0.1:80" /usr/local/aemonitor/apache2/conf/httpd.conf > /dev/null

if [ $? -ne 0 ] ; then
sed -i -e "170i  ServerName 127.0.0.1:80" /usr/local/aemonitor/apache2/conf/httpd.conf 
fi


### Stopping aeMonitor 
echo "#"
echo "##### Initialize Databases #####"
#/usr/local/aemonitor/ctlscript.sh stop
/usr/local/aemonitor/ctlscript.sh start mysql > /dev/null

#/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock drop GWCollageDB 2>&1 > /dev/null <<EOF
#y
#EOF
#/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock drop monarch 2>&1 > /dev/null <<EOF
#y
#EOF
#/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock drop guava 2>&1 > /dev/null <<EOF
#y
#EOF
#/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock drop dashboard 2>&1 > /dev/null <<EOF
#y
#EOF


#### Foundation DB inisitalize
cd $WDIR
/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock create GWCollageDB 2>&1 > /dev/null
/usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock GWCollageDB <./database_data/GWCollageDB.sql 2>&1 > /dev/null

#### monarch DB Intialize
#cd /usr/local/aemonitor/core/databases
#cd $WDIR
/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock create monarch 2>&1 > /dev/null
/usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock monarch < ./database_data/monarch.sql 2>&1 > /dev/null

#### guava DB Initialize
#cd $WDIR
/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock create guava 2>&1 > /dev/null
/usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock guava < ./database_data/guava.sql 2>&1 > /dev/null

#### dashboad DB Initialize
/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock create dashboard 2>&1 > /dev/null
/usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock dashboard < ./database_data/dashboard.sql 2>&1 > /dev/null


#### DO commit to Nagios
echo "#"
echo "##### Commit (Write DB data to the running environemnt) #####"
/usr/local/aemonitor/ctlscript.sh start gwservices > /dev/null

sleep 5
#### Clear LogMessage table of GWCollageDB

echo "set foreign_key_checks = 0;" > tmp.sql
echo "TRUNCATE TABLE LogMessage;"  >> tmp.sql
/usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock GWCollageDB < tmp.sql

#echo "TRUNCATE TABLE LogMessage;" | /usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock GWCollageDB

sleep 5
cd $WDIR
#cp ./commit.pl /usr/local/aemonitor/core/monarch/cgi-bin/monarch/commit.pl
#chmod +x /usr/local/aemonitor/core/monarch/cgi-bin/monarch/commit.pl
sudo -u nagios /usr/local/aemonitor/perl/bin/perl /usr/local/aemonitor/core/monarch/cgi-bin/monarch/commit.pl
sleep 5
/usr/local/aemonitor/ctlscript.sh stop > /dev/null

### Add cron jobs
echo "#"
echo "##### Registrate CRON table #####"
crontab -u nagios crontab-nagios
/etc/init.d/crond restart
#systemctl restart crond.service

### Delete work file  
rm aemonitor-v4.tar.gz crontab-nagios
rm -rf ./database_data tmp.sql

### restart aeMonitor 
echo "#"
echo "##### Start aeMonitor #####"
/usr/local/aemonitor/ctlscript.sh start

###
rm /usr/local/aemonitor/R*
cd $WDIR
cp aemonitor-uninstall.sh /usr/local/aemonitor/.
chown nagios.nagios /usr/local/aemonitor/aemonitor-uninstall.sh
cp README /usr/local/aemonitor/.
chown nagios.nagios /usr/local/aemonitor/README
echo "##### Finish the instration #####"
