#!/bin/bash
#
#  aeMonitor Installation script 
#  Ver 2.0
#  Date 2014.02.17
#  Auther: Shinji Hirose @ Praesentia
#  (c) 2014 Praesentia Corp. All rights reserved 

WDIR=`pwd`
HN=`hostname`
LOG=/var/tmp/aeMonitor-install-`date +%Y%m%d`.log

echo "##### インストールの準備をします #####"
echo "#"

tar -xf data >/dev/null 2>&1

########
#
echo "##### インストール環境をチェックします #####"
echo "#"
SL=`getenforce`

if [ $SL = "Disabled" ]
then
  echo "SELINUX チェック：OK"

else
  echo "インストール環境に問題があります：SELINUX設定が $SL でした。インストールを停止します。"
  echo "vi /etc/sysconfig/selinux コマンドで selinux ファイルを編集し、"
  echo "SELINUX=disabled にして保存してから、再起動してください。"
  exit 1
fi

grep $HN /etc/sysconfig/network > /dev/null
if [ $? = 1 ]; then
   echo "/etc/sysconfig/network の HOSTNAME が設定されていません。インストールを停止します。"
  exit 1
fi
  echo "/etc/sysconfig/network チェック：OK"

grep $HN /etc/hosts > /dev/null
if [ $? = 1 ]; then
   echo "/etc/hosts にホスト名のアドレスが設定されていません。インストールを停止します。"
  exit 1
fi
  echo "/etc/hosts チェック：OK"

#### Add group & user
#
echo "#"
echo "##### ユーザとグループを追加します #####"
getent group | grep mysql > /dev/null
if [ $? -ne 0 ] ; then
groupadd mysql
fi
getent group | grep nagios > /dev/null
if [ $? -ne 0 ] ; then
groupadd nagios
fi
getent passwd | grep mysql > /dev/null
if [ $? -ne 0 ] ; then
useradd -g mysql mysql
fi
getent passwd | grep nagios > /dev/null
if [ $? -ne 0 ] ; then
useradd -g nagios nagios
fi

#### extract aeMonitor files 
#
echo "#"
echo "##### aeMonitor パッケージを展開しています #####"
#cp aemonitor-gwm.tar /usr/local/.
#cd /usr/local
tar -Pzxf aemonitor-v301.tar.gz

#rm aemonitor-gwm.tar

#
#rm /usr/local/aemonitor/nagios/var/*.log
rm /usr/local/aemonitor/nagios/var/*.sav
rm /usr/local/aemonitor/nagios/var/*.tmp
#rm /usr/local/aemonitor/nagios/var/*.lock
rm /usr/local/aemonitor/nagios/var/objects.cache

#### make rc files 
#
echo "#"
echo "##### 起動環境を設定しています #####"
echo "#!/bin/sh" > /etc/rc.d/init.d/aemonitor
echo "#" >> /etc/rc.d/init.d/aemonitor
echo "#" >> /etc/rc.d/init.d/aemonitor
echo "# aeMonitor start/shutdown script" >> /etc/rc.d/init.d/aemonitor
echo "#" >> /etc/rc.d/init.d/aemonitor
echo "exec /usr/local/aemonitor/ctlscript.sh \"\$@\"" >> /etc/rc.d/init.d/aemonitor

chmod 755 /etc/rc.d/init.d/aemonitor

cd /etc/rc0.d
ln -s ../init.d/aemonitor K30aemonitor
cd /etc/rc1.d
ln -s ../init.d/aemonitor K30aemonitor
cd /etc/rc6.d
ln -s ../init.d/aemonitor K30aemonitor

cd /etc/rc.d/rc2.d  
ln -s ../init.d/aemonitor S80aemonitor
cd /etc/rc.d/rc3.d  
ln -s ../init.d/aemonitor S80aemonitor
cd /etc/rc.d/rc4.d  
ln -s ../init.d/aemonitor S80aemonitor
cd /etc/rc.d/rc5.d  
ln -s ../init.d/aemonitor S80aemonitor

#### Changing IPtable 
#
echo "#"
echo "##### IP Table 設定：HTTPをオープンします #####"

ACCPORT1="-A INPUT -p tcp -m state --state NEW -m tcp --dport 80 -j ACCEPT"

grep "^[^#].*dport 80" /etc/sysconfig/iptables > /dev/null

if [ $? -eq 1 ]; then
  sed -i -e "10i $ACCPORT1" /etc/sysconfig/iptables
fi

/etc/init.d/iptables restart >>$LOG 2>&1

#### Edit httpd.conf :  add ServerName
#
grep "^\s*ServerName 127.0.0.1:80" /usr/local/aemonitor/apache2/conf/httpd.conf > /dev/null

if [ $? -ne 0 ] ; then
sed -i -e "170i  ServerName 127.0.0.1:80" /usr/local/aemonitor/apache2/conf/httpd.conf 
fi


### Stopping aeMonitor 
echo "#"
echo "##### データベースを初期化します #####"
#/usr/local/aemonitor/ctlscript.sh stop
/usr/local/aemonitor/ctlscript.sh start mysql > /dev/null

#/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock drop GWCollageDB 2>&1 > /dev/null <<EOF
#y
#EOF
#/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock drop monarch 2>&1 > /dev/null <<EOF
#y
#EOF
#/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock drop guava 2>&1 > /dev/null <<EOF
#y
#EOF
#/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock drop dashboard 2>&1 > /dev/null <<EOF
#y
#EOF


#### Foundation DB inisitalize
cd $WDIR
/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock create GWCollageDB 2>&1 > /dev/null
/usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock GWCollageDB <./database_data/GWCollageDB.sql 2>&1 > /dev/null

#### monarch DB Intialize
#cd /usr/local/aemonitor/core/databases
#cd $WDIR
/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock create monarch 2>&1 > /dev/null
/usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock monarch < ./database_data/monarch.sql 2>&1 > /dev/null

#### guava DB Initialize
#cd $WDIR
/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock create guava 2>&1 > /dev/null
/usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock guava < ./database_data/guava.sql 2>&1 > /dev/null

#### dashboad DB Initialize
/usr/local/aemonitor/mysql/bin/mysqladmin -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock create dashboard 2>&1 > /dev/null
/usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock dashboard < ./database_data/dashboard.sql 2>&1 > /dev/null


#### DO commit to Nagios
echo "#"
echo "##### データベースをコミットします #####"
/usr/local/aemonitor/ctlscript.sh start gwservices > /dev/null

sleep 2
#### Clear LogMessage table of GWCollageDB

echo "set foreign_key_checks = 0;" > tmp.sql
echo "TRUNCATE TABLE LogMessage;"  >> tmp.sql
/usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock GWCollageDB < tmp.sql

#echo "TRUNCATE TABLE LogMessage;" | /usr/local/aemonitor/mysql/bin/mysql -u root --socket=/usr/local/aemonitor/mysql/tmp/mysql.sock GWCollageDB

sleep 2
cd $WDIR
#cp ./commit.pl /usr/local/aemonitor/core/monarch/cgi-bin/monarch/commit.pl
#chmod +x /usr/local/aemonitor/core/monarch/cgi-bin/monarch/commit.pl
sudo -u nagios /usr/local/aemonitor/perl/bin/perl /usr/local/aemonitor/core/monarch/cgi-bin/monarch/commit.pl
sleep 2
/usr/local/aemonitor/ctlscript.sh stop > /dev/null

### Add cron jobs
echo "#"
echo "##### クロンジョブを登録します #####"
crontab -u nagios crontab-nagios
/etc/init.d/crond restart

### Delete work file  
rm aemonitor-v301.tar.gz crontab-nagios
rm -rf ./database_data tmp.sql

### restart aeMonitor 
echo "#"
echo "##### aeMonitorを開始します #####"
/usr/local/aemonitor/ctlscript.sh start

###
rm /usr/local/aemonitor/R*
cd $WDIR
cp aemonitor-uninstall.sh /usr/local/aemonitor/.
chown nagios.nagios /usr/local/aemonitor/aemonitor-uninstall.sh
cp README /usr/local/aemonitor/.
chown nagios.nagios /usr/local/aemonitor/README
