# MonArch - Groundwork Monitor Architect
# MonarchForms.pm
#
############################################################################
# Release 3.1    November  2009
# Release 3.1J   September 2013 (Praesentia Corp.)
# Release 3.1J-3 Jul 2014       (Praesentia Corp.)
############################################################################
#
# Original author: Scott Parris
#
# Copyright 2007, 2008, 2009 GroundWork Open Source, Inc. (GroundWork)
# All rights reserved. This program is free software; you can redistribute
# it and/or modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

use strict;
use MonarchInstrument;

package Forms;

my $doc_root_monarch = '/monarch';
my $cgi_dir          = '/cgi-bin';
my $form_class       = 'row1';
my $global_cell_pad  = 3;
my $cgi_exe          = 'monarch.cgi';
if ( -e '/usr/local/aemonitor/config/db.properties' ) {
    $cgi_dir = '/monarch/cgi-bin';
}

my $disable_test_buttons = 0;  # set to 0 or 1

my $image_dir    = "$doc_root_monarch/images";
my $download_dir = "$doc_root_monarch/download";
my $extend_page  = '<br><br><a href=#></a><a href=#></a><br><br>';

sub members(@) {
    my $title      = $_[1];
    if ($title eq 'Members:'){$title ="メンバー:"}
    my $name       = $_[2];
    my $members    = $_[3];
    my $nonmembers = $_[4];
    my $req        = $_[5];
    my $size       = $_[6];
    my $doc        = $_[7];
    my $override   = $_[8];
    my $tab        = $_[9];
    my $tabindex   = $tab ? "tabindex=\"$tab\"" : '';
    if ( !$size ) { $size = 10 }

    if ($req) {
	$req = "<td class=$form_class valign=top><font color=#CC0000>&nbsp;* 必須</font></td>";
    }
    my @members    = @{$members};
    my @nonmembers = @{$nonmembers};
    my $detail     = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);
    if ($override) {
	if ( $override eq 'checked' ) {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override checked></td>";
	}
	else {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override></td>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class valign=top width="25%">$title</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class>
<table cellspacing=0 align=left border=0>
<tr>
<td class=$form_class align=left>
<select name=$name id=members size=$size multiple $tabindex>);
    @members = sort { lc($a) cmp lc($b) } @members;
    foreach my $mem (@members) {
	$detail .= "\n<option value=\"$mem\">$mem</option>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>
</td>
<td class=$form_class cellpadding=$global_cell_pad align=left>
<table cellspacing=0 cellpadding=3 align=center border=0>
<tr>
<td class=$form_class align=center>
<input class=submitbutton type=button value="削除 >>" onclick="delIt();" $tabindex>
</td>
</tr>
<tr>
<td class=$form_class align=center>
<input class=submitbutton type=button value="&nbsp;&nbsp;<< 追加&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" onclick="addIt();" $tabindex>
</td>
</tr>
</table>
</td>
<td class=$form_class align=left>
<select name=nonmembers id=nonmembers size=$size multiple $tabindex>);
    my $got_mem = undef;
    @nonmembers = sort { lc($a) cmp lc($b) } @nonmembers;
    foreach my $nmem (@nonmembers) {
	foreach my $mem (@members) {
	    if ( $nmem eq $mem ) { $got_mem = 1 }
	}
	if ($got_mem) {
	    $got_mem = undef;
	    next;
	}
	else {
	    $detail .= "\n<option value=\"$nmem\">$nmem</option>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>
</td>
$req
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub hidden(@) {
    my $hidden = $_[1];
    my %hidden = %{$hidden};
    my $detail = undef;
    foreach my $key ( sort keys %hidden ) {
	if ( $hidden{$key} ) {
	    $detail .= "\n<input type=hidden name=\"$key\" value=\"$hidden{$key}\">";
	}
    }
    return $detail;
}

sub checkbox(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $value    = $_[3];
    my $doc      = $_[4];
    my $override = $_[5];
    my $tab      = $_[6];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my %pp = StorProc->fetch_one( 'setup', 'name', 'enable_detail_conf' );
    my $edc = $pp{'value'};

    my $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]});
    if (!$edc && $name =~ /process_perf_data|retain_status_information|flap_detection_enabled|retain_nonstatus_information|active_checks_enabled|passive_checks_enabled|obsess_over_host|check_freshness/) {
    $detail      .= qq( <tr style="display:none">);
    } elsif (!$edc && $name =~ /is_volatile|parallelize_check|obsess_over_service/){
    $detail      .= qq( <tr style="display:none">);
} else {
    $detail      .= qq( <tr>);
    }
    $detail      .= qq(
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);

    if ($override) {
	if ( $override eq 'checked' ) {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override checked></td>";
	}
	else {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override></td>";
	}
    }
if ($title eq 'Process perf data:'){$title ="性能データの処理:"}
if ($title eq 'Retain status information:'){$title ="ステータス情報の保持:"}
if ($title eq 'Flap detection enabled:'){$title ="フラッピング検出の有効化:"}
if ($title eq 'Retain nonstatus information:'){$title ="ステータス以外の情報保持:"}
if ($title eq 'Active checks enabled:'){$title ="アクティブチェックの有効化:"}
if ($title eq 'Passive checks enabled:'){$title ="パッシブチェックの有効化:"}
if ($title eq 'Obsess over host:'){$title ="ホストのオブセスオーバー:"}
if ($title eq 'Check freshness:'){$title ="情報鮮度チェック:"}
if ($title eq 'Event handler enabled:'){$title ="イベントハンドラの有効化:"}
if ($title eq 'Event handler:'){$title ="イベントハンドラ:"}
if ($title eq 'Notifications enabled:'){$title ="通知の有効化:"}
if ($title eq 'Is volatile:'){$title ="揮発性:"}
if ($title eq 'Parallelize check:'){$title ="チェックの並列実行:"}
if ($title eq 'Obsess over service:'){$title ="サービスのオブセスオーバ:"}
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class width="25%">$title</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "</td>\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class>);
    if ( $value == 1 ) {
	$detail .= "\n<input class=$form_class type=checkbox name=$name value=1 checked $tabindex>";
    }
    else {
	$detail .= "\n<input class=$form_class type=checkbox name=$name value=1 $tabindex>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub checkbox_override(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $value    = $_[3];
    my $doc      = $_[4];
    my $tab      = $_[5];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="2%" align=left>);

    if ($value) {
	$detail .= "\n<input class=$form_class type=checkbox name=$name checked onClick=\"submit()\" $tabindex>";
    }
    else {
	$detail .= "\n<input class=$form_class type=checkbox name=$name onClick=\"submit()\" $tabindex>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class width="23%" align=left>$title</td>);
    if ($doc) {
	$detail .= "\n<td class=$form_class valign=top align=left>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "</td>\n<td class=$form_class width='3%' align=left>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub checkbox_left(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $value    = $_[3];
    my $override = $_[4];
    my $tab      = $_[5];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%" align=right>);

    if ( $value == 1 ) {
	$detail .= "\n<input class=$form_class type=checkbox name=$name value=1 checked $tabindex>";
    }
    else {
	$detail .= "\n<input class=$form_class type=checkbox name=$name value=1 $tabindex>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class>$title</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub checkbox_list(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $list     = $_[3];
    my @list     = @{$list};
    my $selected = $_[4];
    my $req      = $_[5];
    my $doc      = $_[6];
    my $override = $_[7];
    my $tab      = $_[8];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    if ($req) { $req = "<font color=#CC0000>&nbsp;* 必須</font>" }
    my @selected = @{$selected};
    my $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);

    if ($override) {
	if ( $override eq 'checked' ) {
	    $detail .=
	      "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override checked $tabindex></td>";
	}
	else {
	    $detail .=
	      "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override $tabindex></td>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class width="25%" valign=top>$title $req</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class>);
    my $got_selected = undef;
    foreach my $item (@list) {
	my $title = $item;
	$title =~ s/_/ /g;
	foreach my $selected (@selected) {
	    if ( $item eq $selected ) { $got_selected = 1 }
	}
	if ($got_selected) {
	    $got_selected = undef;
	    $detail .= "\n<input class=$form_class type=checkbox name=$name value=\"$item\" checked $tabindex>&nbsp;\u$title<br>";
	}
	else {
	    $detail .= "\n<input class=$form_class type=checkbox name=$name value=\"$item\" $tabindex>&nbsp;\u$title<br>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub list_box_multiple(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $list     = $_[3];
    my @list     = @{$list};
    my $selected = $_[4];
    my $req      = $_[5];
    my $doc      = $_[6];
    my $override = $_[7];
    my $tab      = $_[8];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    if ($req) {
	$req = "<td class=$form_class valign=top><font color=#CC0000>&nbsp;* required</font></td>";
    }
    my @selected = @{$selected};
    my $display  = $title;
    my $size = 7;
    $display =~ s/://g;
if ($title eq 'ホスト通知コマンド'){$title ="ホスト通知コマンド:"; $size = 5;}
if ($title eq 'サービス通知コマンド'){$title ="サービス通知コマンド:"; $size = 5;}
if ($title eq 'Host notification commands:'){$title ="ホスト通知コマンド:"; $size = 5;}
if ($title eq 'Service notification commands:'){$title ="サービス通知コマンド:"; $size = 5;}
    if ( $display =~ /^use$/i ) { $display = "template" }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);
    if ($override) {

	if ( $override eq 'checked' ) {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override checked></td>";
	}
	else {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override></td>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class valign=top width="25%">$title</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class>
<table cellspacing=0 align=left border=0>
<tr>
<td class=$form_class>
<select name=$name size=$size multiple $tabindex>);
    if ( !$list[0] ) {
	$detail .= "\n<option selected value=''></option>";
	$detail .= "\n<option value=''>-- \L$display"."なし --</option>";
    }
    else {
	if ( !$selected[0] ) {
	    $detail .= "\n<option selected value=''></option>";
	}
	else {
	    $detail .= "\n<option value=''></option>";
	}
	my $got_selected = undef;
	@list = sort { lc($a) cmp lc($b) } @list;
	foreach my $item (@list) {
	    foreach my $selected (@selected) {
		if ( $item eq $selected ) { $got_selected = 1 }
	    }
	    if ($got_selected) {
		$got_selected = undef;
		$detail .= "\n<option selected value=\"$item\">$item</option>";
	    }
	    else {
		$detail .= "\n<option value=\"$item\">$item</option>";
	    }
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>
 $req
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub list_box(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $list     = $_[3];
    my $selected = $_[4];
    my $req      = $_[5];
    my $doc      = $_[6];
    my $override = $_[7];
    my $tab      = $_[8];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    if ($req) { $req = "<font color=#CC0000>&nbsp;* 必須</font>" }
    my @list    = @{$list};
    my $display = $title;
    $display =~ s/://g;
    if ( $display =~ /^use$/i ) { $display = "template" }
## for simple monarch and nagios 4.x
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>);
    my %pp = StorProc->fetch_one( 'setup', 'name', 'enable_detail_conf' );
    my $edc = $pp{'value'};
    if (!$edc) {
        if ( $name =~ /ext_info|icon_image|statusmap_image|extended_info|escalation/ ){
            $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr style="display:none">);
        }
    }
#
$detail .= qq(
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);

    if ($override) {
	if ( $override eq 'checked' ) {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override checked></td>";
	}
	else {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override></td>";
	}
    }
if ($title eq 'Event handler:'){$title ="イベントハンドラ"}
if ($title eq 'Notification period:'){$title ="通知時間帯"}
if ($title eq 'Check command:'){$title ="チェックコマンド"}
if ($title eq 'Check period:'){$title ="チェック時間帯"}
if ($title eq 'Service name:'){$title ="サービス名"}
if ($title eq 'Icon image:'){$title ="アイコン画像"}
if ($title eq 'Service:'){$title ="サービス"}
if ($title eq 'Host:'){$title ="ホスト"}
if ($title eq 'Host escalation id:'){$title ="ホストエスカレーションID"}
if ($title eq 'Service escalation id:'){$title ="サービスエスカレーションID"}
if ($title eq 'Vrml image:'){$title ="VRML画像"}
if ($title eq 'Statusmap image:'){$title ="ステータスマップ画像"}
if ($title eq 'Host notification period:'){$title ="ホスト通知時間帯"}
if ($title eq 'Service notification period:'){$title ="サービス通知時間帯"}
if ($title eq 'Escalation period:'){$title ="エスカレーション時間帯"}

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class width="25%">$title</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>\n</td>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;</td>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class align=left>
<select name=$name $tabindex> $req);
    if ( !$list[0] ) {
	$detail .= "\n<option selected value=''></option>";
	$detail .= "\n<option value=''>-- \L$display"."なし --</option>";
    }
    else {
	if ($selected) {
	    $detail .= "\n<option value=''></option>";
	}
	else {
	    $detail .= "\n<option selected value=''></option>";
	}
	@list = sort { lc($a) cmp lc($b) } @list;
	foreach my $item (@list) {
	    if ( $item eq $selected ) {
		$detail .= "\n<option selected value=\"$item\">$item</option>";
	    }
	    else {
		$detail .= "\n<option value=\"$item\">$item</option>";
	    }
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>$req
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub list_box_submit(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $list     = $_[3];
    my $selected = $_[4];
    my $req      = $_[5];
    my $doc      = $_[6];
    my $tab      = $_[7];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    if ($req) { $req = "<font color=#CC0000>&nbsp;* 必須</font>" }
    my @list    = @{$list};
    my $display = $title;
    $display =~ s/://g;
    if ( $display =~ /^use$/i ) { $display = "template" }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>);
    my %pp = StorProc->fetch_one( 'setup', 'name', 'enable_detail_conf' );
    my $edc = $pp{'value'};
    if (!$edc) {
        if ( $name =~ /escalation/){
            $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr style="display:none">);
        }
    }
$detail .= qq(<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%">$title</td>);

    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class align=left>
<select name=$name onChange="submit()" $tabindex> $req);
    if ( !$list[0] ) {
	$detail .= "\n<option selected value=''></option>";
	$detail .= "\n<option value=''>-- \L$display" . "なし --</option>";
    }
    else {
	if ($selected) {
	    $detail .= "\n<option value=''>-- そのまま --</option>";
	}
	else {
	    $detail .= "\n<option selected value=''></option>";
	}
	@list = sort { lc($a) cmp lc($b) } @list;
	foreach my $item (@list) {
	    if ( $item eq $selected ) {
		$detail .= "\n<option selected value=\"$item\">$item</option>";
	    }
	    else {
		$detail .= "\n<option value=\"$item\">$item</option>";
	    }
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>$req
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub command_test() {
    my $results      = $_[1];
    my $host         = $_[2];
    my $args         = $_[3];
    my $service_desc = $_[4];
    my $tab          = $_[5];
    my $tabindex     = $tab ? "tabindex=\"$tab\"" : '';
    my $button_class = $disable_test_buttons ? 'submitbutton_disabled' : 'submitbutton';
    my $test_enabled = $disable_test_buttons ? 'disabled' : '';

    unless ($results) { $results = "$args<br>" }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0 style="table-layout: fixed;">
<tr>
<td class=$form_class valign=top width="7%">テスト:</td>
<td class=$form_class width="92%">

<table width=auto cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=$form_class align=right>ホスト:&nbsp;</td>
<td class=$form_class><input type=text size=50 name=host value="$host" $tabindex></td>
</tr>
<tr>
<td class=$form_class align=right>引数:&nbsp;</td>
<td class=$form_class><input type=text size=60 name=arg_string value="$args" $tabindex></td>
</tr>
<tr>
<td class=$form_class align=right>サービスの説明:&nbsp;&nbsp;</td>
<td class=$form_class><input type=text size=60 name=service_desc value="$service_desc" $tabindex></td>
</tr>
</table>

</td>
<td class=$form_class width="1%" align=center>&nbsp;</td>
</tr>
<tr>
<td class=$form_class width="7%" align=center><input class=submitbutton type=submit name=test_command value="テスト" $tabindex></td>
<td class=output valign=top width="92%" align=left>$results</td>
<td class=$form_class width="1%">&nbsp;</td>
</tr>
<tr>
<td class=$form_class colspan=3 style="height: 0.5em;"></td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub test_service_check() {
    my $results  = $_[1];
    my $host     = $_[2];
    my $args     = $_[3];
    my $tab      = $_[4];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my $button_class = $disable_test_buttons ? 'submitbutton_disabled' : 'submitbutton';
    my $test_enabled = $disable_test_buttons ? 'disabled' : '';

    unless ($results) { $results = "$args<br>" }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0 style="table-layout: fixed;">
<tr>
<td class=$form_class valign=top width="7%">テスト:</td>
<td class=$form_class width="92%">ホスト:&nbsp;&nbsp;<input type=text size=50 name=host value="$host" $tabindex></td>
<td class=$form_class width="1%" align=center>&nbsp;</td>
</tr>
<tr>
<td class=$form_class width="7%" align=center><input class=submitbutton type=submit name=test_command value="テスト" $tabindex></td>
<td class=output valign=top width="92%" align=left>$results</td>
<td class=$form_class width="1%">&nbsp;</td>
</tr>
<tr>
<td class=$form_class colspan=3 style="height: 0.5em;"></td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub command_select() {
    my $list     = $_[1];
    my $selected = $_[2];
    my $tab      = $_[3];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my @list     = @{$list};
    my %selected = %{$selected};

    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    my $temp = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=task value=new_plugin $selected{'d'}>
</td>
<td class=$form_class>
Install plugin
</td>
<td class=$form_class>
&nbsp;
</td>
</tr>);
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=task value=resource $selected{'d'}>
</td>
<td class=$form_class>
New command from an existing plugin
</td>
<td class=$form_class>
&nbsp;
</td>
</tr>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=task value=copy $selected{'d'}>
</td>
<td class=$form_class>
Clone a command:
</td>
<td class=$form_class align=left>
<select name=source>);
    if ( !$list[0] ) {
	$detail .= "\n<option selected value=''></option>";
	$detail .= "\n<option value=''>-- チェックコマンドなし --</option>";
    }
    else {
	if ($selected) {
	    $detail .= "\n<option value=''></option>";
	}
	else {
	    $detail .= "\n<option selected value=''></option>";
	}
	@list = sort { lc($a) cmp lc($b) } @list;
	foreach my $item (@list) {
	    if ( $item eq $selected ) {
		$detail .= "\n<option selected value=\"$item\">$item</option>";
	    }
	    else {
		$detail .= "\n<option value=\"$item\">$item</option>";
	    }
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>
</td>
</tr>

);

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub display_hidden(@) {
    my $title  = $_[1];
    my $name   = $_[2];
    my $value  = $_[3];
    my $doc    = $_[4];
    my $parent = $_[5];
    if ($parent) { $form_class = 'parent' }
    my $display = $value;
    my $detail  = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%" valign=top>$title</td>);

    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class>$display
<input type=hidden name=$name value="$value">
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub text_box(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $value    = $_[3];
    my $size     = $_[4];
    my $req      = $_[5];
    my $doc      = $_[6];
    my $override = $_[7];
    my $tab      = $_[8];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    if ( !$size ) { $size = 50 }
    if ($req)     { $req  = "<font color=#CC0000>&nbsp;* 必須</font>" }
    $value =~ s/</&lt;/g;
    $value =~ s/>/&gt;/g;
    $value =~ s/\"/&quot;/g;
  
my $simple_flag = 0;
if ($title eq 'フラッピングしきい(下限)値:'
    || $title eq 'フラッピングしきい(上限)値:'
    || $title eq '情報鮮度のしきい値:'
    || $title eq '最大チェック試行回数:'
    || $title eq 'チェック間隔:'
    || $name eq 'coords2d'
    || $name eq 'coords3d'
   ){ 
   $simple_flag = 1;
}
if ($title eq 'Low flap threshold:'){$title ="フラッピングしきい(下限)値："}
if ($title eq 'High flap threshold:'){$title ="フラッピングしきい(上限)値："}
if ($title eq 'Freshness threshold:'){$title ="情報鮮度のしきい値:"}
if ($title eq 'Max check attempts:'){$title ="最大チェック試行回数:"}
if ($title eq 'Check interval:'){$title ="チェック間隔:"}
if ($title eq 'Notification interval:'){$title ="通知間隔:"}
if ($title eq 'Action url:'){$title ="処置URL:"}
if ($title eq 'Notes:'){$title ="注記:"}

if ($title eq 'Notes url:'){$title ="注記URL:"}
if ($title eq 'Icon image alt:'){$title ="アイコン画像代替文字列:"}
if ($title eq 'Alias:'){$title ="エイリアス:"}
if ($title eq '2d coords:'){$title ="2D座標:"}
if ($title eq '3d coords:'){$title ="3D座標:"}
if ($title eq 'First notification:'){$title ="通知開始"}
if ($title eq 'Last notification:'){$title ="通知終了"}
if ($title eq 'Sunday:'){$title ="日曜日:"}
if ($title eq 'Monday:'){$title ="月曜日:"}
if ($title eq 'Tuesday:'){$title ="火曜日:"}
if ($title eq 'Wednesday:'){$title ="水曜日:"}
if ($title eq 'Thursday:'){$title ="木曜日:"}
if ($title eq 'Friday:'){$title ="金曜日:"}
if ($title eq 'Saturday:'){$title ="土曜日:"}
if ($title eq 'Normal check interval:'){$title ="定期チェック間隔:"}
if ($title eq 'Retry check interval:'){$title ="再チェック間隔:"}

my $detail = "";
#  ADD for simple monarch 2014.5.26
#
        my %pp = StorProc->fetch_one( 'setup', 'name', 'enable_detail_conf' );
        my $edc = $pp{'value'};

        if ($edc) {
#
    $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>);
} elsif ($simple_flag eq 0){ 
    $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>);
} else {
    $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr style="display:none">);
}

$detail .= qq(
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);

    if ($override) {
	if ( $override eq 'checked' ) {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override checked></td>";
	}
	else {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override></td>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class width="25%">$title</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class>
<input type=text size=$size name=$name value="$value" $tabindex>$req
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub password_box(@) {
    my $title = $_[1];
    my $name  = $_[2];
    my $size  = $_[3];
    my $req   = $_[4];
    if ( !$size ) { $size = 50 }
    if ($req)     { $req  = "<font color=#CC0000>&nbsp;* 必須</font>" }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%">$title</td>
<td class=$form_class width="3%" align=center>&nbsp;</td>
<td class=$form_class>
<input type=password size=$size name=$name value=''>$req
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub text_area(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $value    = $_[3];
    my $rows     = $_[4];
    my $size     = $_[5];
    my $req      = $_[6];
    my $doc      = $_[7];
    my $override = $_[8];
    my $tab      = $_[9];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    if ( !$rows ) { $rows = 3 }
    if ( !$size ) { $size = 40 }
    my $label_width  = '25%';
    my $text_width   = '';

    if ($size eq '100%') {
	$size         = 40;
	$label_width  = '2%';
	$text_width   = 'style="width: 99%;"';
    }
    if ($req) { $req = "<font color=#CC0000>&nbsp;* 必須</font>" }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);

    if ($override) {
	if ( $override eq 'checked' ) {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override checked></td>";
	}
	else {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override></td>";
	}
    }
if ($title eq 'Command line:'){$title ="コマンドライン:"}
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class valign=top width="$label_width">$title</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a></td>";
    }
    elsif (! $text_width) {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;</td>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class><textarea name=$name rows=$rows cols=$size $text_width wrap=soft $tabindex>$value</textarea>$req</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub stalking_options(@) {
    my $selected = $_[1];
    my $req      = $_[2];
    my $doc      = $_[3];
    my $override = $_[4];
    my $tab      = $_[5];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    if ($req) { $req = "<font color=#CC0000>&nbsp;* 必須</font>" }
    my @selected = @{$selected};
#
#  Changed for simple monarch 2014.5.26
#
    my $detail   = "";
    my %pp = StorProc->fetch_one( 'setup', 'name', 'enable_detail_conf' );
    my $edc = $pp{'value'};
    if ($edc) {
    $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>);
    } else {
   $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr  style="display:none">);
    }
##
$detail   .= qq( <td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);

    if ($override) {
	if ( $override eq 'checked' ) {
	    $detail .=
"\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=stalking_options_override value=1 checked></td>";
	}
	else {
	    $detail .=
"\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=stalking_options\_override value=1></td>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class width="25%" valign=top>ストーキングオプション: $req</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class>);
    my @opts = ( 'd', 'o', 'u' );
    my $desc = undef;
    foreach my $opt (@opts) {
	if ( $opt =~ 'd' ) {
	    $desc = '停止(DOWN)';
	}
	elsif ( $opt =~ 'o' ) {
	    $desc = '稼動(UP)';
	}
	elsif ( $opt =~ 'u' ) {
	    $desc = '到達不能(UNREACHABLE)';
	}
	my $got_opt = undef;
	foreach my $sel (@selected) {
	    if ( $sel eq $opt ) { $got_opt = 1 }
	}
	if ($got_opt) {
	    $detail .= "\n<input class=$form_class type=checkbox name=stalking_options value=$opt checked $tabindex>&nbsp;\u$desc $req<br>";
	}
	else {
	    $detail .= "\n<input class=$form_class type=checkbox name=stalking_options value=$opt $tabindex>&nbsp;\u$desc $req<br>";
	}
	$req = undef;
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub notification_options(@) {
    my $obj        = $_[1];
    my $name       = $_[2];
    my $selected   = $_[3];
    my $req        = $_[4];
    my $nagios_ver = $_[5];
    my $doc        = $_[6];
    my $override   = $_[7];
    my $tab        = $_[8];
    my $tabindex   = $tab ? "tabindex=\"$tab\"" : '';
    if ($req) { $req = "<font color=#CC0000>&nbsp;* 必須</font>" }
    my @selected = @{$selected};
    my $title    = $name;
### Modify 2014.5.28
    my %pp = StorProc->fetch_one( 'setup', 'name', 'enable_detail_conf' );
    my $edc = $pp{'value'};
###
    $title =~ s/_/ /g;
###
    if ($title eq 'notification options'){$title ="通知オプション"}
    if ($title eq 'escalation options'){$title ="エスカレーションオプション"}
    if ($title eq 'host notification options'){$title ="ホスト通知オプション"}
    if ($title eq 'service notification options'){$title ="サービス通知オプション"}
###    
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);

    if ($override) {
	if ( $override eq 'checked' ) {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override checked></td>";
	}
	else {
	    $detail .= "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override></td>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class width="25%" valign=top>\u$title:</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class>);
    my @opts = ();
    if ( $obj =~ /service_escalation/ ) {
	@opts = ( 'r', 'w', 'u', 'c' );
    }
    elsif ( $obj =~ /escalation/ ) {
	@opts = ( 'r', 'd', 'u' );
    }
    elsif ( $obj =~ /contact/ && $name =~ /service/ ) {
	@opts = ( 'u', 'c', 'w', 'r' );
        if ($edc){
	if ( $nagios_ver =~ /^[23]\.x$/ ) { push @opts, 'f'; }
	if ( $nagios_ver =~ /^[3]\.x$/ )  { push @opts, 's'; }
        }
	push @opts, 'n';
    }
    elsif ( $obj =~ /contact/ && $name =~ /host/ ) {
	@opts = ( 'd', 'u', 'r' );
        if ($edc){
	if ( $nagios_ver =~ /^[23]\.x$/ ) { push @opts, 'f'; }
	if ( $nagios_ver =~ /^[3]\.x$/ )  { push @opts, 's'; }
        }
	push @opts, 'n';
    }
    elsif ( $obj =~ /service/ ) {
	@opts = ( 'u', 'c', 'w', 'r' );
        if ($edc){
	if ( $nagios_ver =~ /^[23]\.x$/ ) { push @opts, 'f'; }
	if ( $nagios_ver =~ /^[3]\.x$/ )  { push @opts, 's'; }
        }
	push @opts, 'n';
    }
    elsif ( $obj =~ /host/ ) {
	@opts = ( 'd', 'u', 'r' );
        if ($edc){
	if ( $nagios_ver =~ /^[23]\.x$/ ) { push @opts, 'f'; }
	if ( $nagios_ver =~ /^[3]\.x$/ )  { push @opts, 's'; }
        }
	push @opts, 'n';
    }
    my $desc = undef;
    foreach my $opt (@opts) {
	if ( $opt =~ 'd' ) {
	    $desc = '停止(DOWN)';
	}
	elsif ( $opt eq 'u' ) {
	    $desc = '到達不能(UNREACHABLE)';
	    if ( $obj =~ /service/ ) { $desc = '不明(UNKNOWN)' }
	    if ( $obj =~ /contact/ && $name =~ /service/ ) { $desc = '不明(UNKNOWN)' }
	}
	elsif ( $opt eq 'r' ) {
	    $desc = '回復(Recovery)';
	}
	elsif ( $opt eq 'c' ) {
	    $desc = '異常(CRITICAL)';
	}
	elsif ( $opt eq 'w' ) {
	    $desc = '警告(WARNING)';
	}
	elsif ( $opt eq 'n' ) {
	    $desc = 'なし';
	}
	elsif ( $opt eq 'f' ) {
	    $desc = 'フラッピング';
	}
	elsif ( $opt eq 's' ) {
	    $desc = '計画停止';
	}
	my $got_opt = undef;
	foreach my $sel (@selected) {
	    if ( $sel eq $opt ) { $got_opt = 1 }
	}
	if ($got_opt) {
	    $detail .= "\n<input class=$form_class type=checkbox name=$name value=$opt $tabindex checked>&nbsp;\u$desc $req<br>";
	}
	else {
	    $detail .= "\n<input class=$form_class type=checkbox name=$name value=$opt $tabindex>&nbsp;\u$desc $req<br>";
	}
	$req = undef;
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub failure_criteria(@) {
    my $name     = $_[1];
    my $selected = $_[2];
    my $req      = $_[3];
    my $type     = $_[4];
    my $doc      = $_[5];
    my $override = $_[6];
    my $tab      = $_[7];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    if ($req) { $req = "<font color=#CC0000>&nbsp;* 必須</font>" }
    my @selected = @{$selected};
    my $title    = $name;
    $title =~ s/_/ /g;
    if ($title eq 'execution failure criteria'){$title ="実行中止基準"}
    if ($title eq 'notification failure criteria'){$title ="通知中止基準"}
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);

    if ($override) {
	if ( $override eq 'checked' ) {
	    $detail .=
	      "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override checked $tabindex></td>";
	}
	else {
	    $detail .=
	      "\n<td class=$form_class width='2%' valign=top><input class=$form_class type=checkbox name=$name\_override $tabindex></td>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class width="25%" valign=top>\u$title:</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class>);
    my @opts = ( 'o', 'w', 'u', 'c', 'n' );
    if ( $type eq 'host_dependencies' ) { @opts = ( 'o', 'd', 'u', 'p', 'n' ) }
    my $desc = undef;
    foreach my $opt (@opts) {
	if ( $opt eq 'o' && $type eq 'host_dependencies' ) {
	    $desc = '稼動(UP)';
	}
	elsif ( $opt eq 'o' ) {
	    $desc = '正常(OK)';
	}
	elsif ( $opt eq 'u' && $type eq 'host_dependencies' ) {
	    $desc = '到達不能(UNREACHABLE)';
	}
	elsif ( $opt eq 'u' ) {
	    $desc = '不明(UNKNOWN)';
	}
	elsif ( $opt eq 'd' ) {
	    $desc = '停止(DOWN)';
	}
	elsif ( $opt eq 'r' ) {
	    $desc = '回復(Recovery)';
	}
	elsif ( $opt eq 'c' ) {
	    $desc = '異常(CRITICAL)';
	}
	elsif ( $opt eq 'w' ) {
	    $desc = '警告(WARNING)';
	}
	elsif ( $opt eq 'p' ) {
	    $desc = '保留(PENDING)';
	}
	elsif ( $opt eq 'n' ) {
	    $desc = 'なし';
	}
	my $got_opt = undef;
	foreach my $sel (@selected) {
	    if ( $sel eq $opt ) { $got_opt = 1 }
	}
	if ($got_opt) {
	    $detail .= "\n<input class=$form_class type=checkbox name=$name value=$opt checked $tabindex>&nbsp;\u$desc $req<br>";
	}
	else {
	    $detail .= "\n<input class=$form_class type=checkbox name=$name value=$opt $tabindex>&nbsp;\u$desc $req<br>";
	}
	$req = undef;
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub submit_button(@) {
    my $name     = $_[1];
    my $value    = $_[2];
    my $tab      = $_[3];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td valign=top class=data align=left>
<table cellpadding=5 cellspacing=1 border=0>
<tr>
<td class=$form_class>
<input class=submitbutton type=submit name=$name value="$value">
</td>
</tr>
</table>
</td>
</tr>);
}

sub form_top(@) {
    my $caption         = $_[1];
    my $onsubmit_action = $_[2];
    my $ez              = $_[3];
    my $boxwidth        = $_[4] || '90%';
    my $align           = 'left';
    if ( $ez eq '1' ) { $cgi_exe = 'monarch_ez.cgi' }
    if ( $ez eq '2' ) { $cgi_exe = 'monarch_auto.cgi' }
if ($caption eq 'Host External'){$caption ="ホスト外部設定"}
if ($caption eq 'Service External'){$caption ="サービス外部設定"}
if ($caption eq 'Service Externals'){$caption ="サービス外部設定"}
if ($caption eq 'Rename Servicegroup'){$caption ="サービスグループ名変更"}
if ($caption eq 'Rename Extended Service Info Template'){$caption ="サービス拡張情報テンプレート名変更"}
if ($caption eq 'Rename Service Dependency Template'){$caption ="サービス依存関係テンプレート名変更"}
if ($caption eq 'Delete Escalation Tree'){$caption ="エスカレーションツリー削除"}
if ($caption eq 'Rename Escalation Tree'){$caption ="エスカレーションツリー名変更"}
if ($caption eq 'Delete Service Escalation Template'){$caption ="サービスエスカレーションテンプレート削除"}
if ($caption eq 'Rename Service Escalation Template'){$caption ="サービスエスカレーションテンプレート名変更"}
if ($caption eq 'Delete Host Escalation Template'){$caption ="ホストエスカレーションテンプレート削除"}
if ($caption eq 'Rename Host Escalation Template'){$caption ="ホストエスカレーションテンプレート名変更"}
if ($caption eq 'Delete Command'){$caption ="コマンド削除"}
if ($caption eq 'Rename Command'){$caption ="コマンド名変更"}
if ($caption eq 'Command'){$caption ="コマンド"}
if ($caption eq 'Delete Extended Service Info Template'){$caption ="サービス拡張情報テンプレート削除"}
if ($caption eq 'Rename Extended Host Info Template'){$caption ="ホスト拡張情報テンプレート名変更"}
if ($caption eq 'Rename Host Template'){$caption ="ホストテンプレート名変更"}
if ($caption eq 'Delete Time Period'){$caption ="時間帯削除"}
if ($caption eq 'Rename Time Period'){$caption ="時間帯名変更"}
if ($caption eq 'Delete Contact Template'){$caption ="通知先テンプレート削除"}
if ($caption eq 'Rename Contact Template'){$caption ="通知先テンプレート名変更"}
if ($caption eq 'Delete Contactgroup'){$caption ="通知先グループ削除"}
if ($caption eq 'Rename Contactgroup'){$caption ="通知先グループ名変更"}
if ($caption eq 'Delete Host Template'){$caption ="ホストテンプレート削除"}
if ($caption eq 'Delete Extended Host Info Template'){$caption ="ホスト拡張情報テンプレート削除"}
if ($caption eq 'Host Template Properties'){$caption ="ホストテンプレート設定"}
if ($caption eq 'Extended Host Info Template'){$caption ="ホスト拡張情報テンプレート設定"}
if ($caption eq 'Service Dependency Template'){$caption ="サービス依存関係テンプレート設定"}
if ($caption eq 'Extended Service Info Template'){$caption ="サービス拡張情報テンプレート設定"}
if ($caption eq 'Hostgroup Properties'){$caption ="ホストグループ設定"}
if ($caption eq 'Contactgroup Properties'){$caption ="通知先グループ設定"}
if ($caption eq 'Contact Template'){$caption ="通知先テンプレート設定"}
if ($caption eq 'Time Period'){$caption ="時間帯"}
if ($caption eq 'Host Escalation '){$caption ="ホストエスカレーション"}
if ($caption eq 'Service Escalation '){$caption ="サービスエスカレーション"}
if ($caption eq 'Confirm Delete'){$caption ="削除確認"}
if ($caption eq 'New Monarch Group'){$caption ="新規Monarchグループ"}
if ($caption eq 'Load Nagios Object Files'){$caption ="Nagiosオブジェクトファイルのロード"}
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" method=post $onsubmit_action generator=form_top>
<table class=data width="$boxwidth" cellpadding=0 cellspacing=1 border=0>
<tr>
<td class=data>
<table width="100%" cellpadding=3 cellspacing=0 align=left border=0>
<tr>
<td class=head colspan=3>&nbsp;$caption</td>
</tr>
</table>
</td>
</tr>);
}

sub form_top_file(@) {
    my $caption         = $_[1];
    my $onsubmit_action = $_[2];
    my $ez              = $_[3];
    my $align           = 'left';

    # next line commented out because now the caller provides the ' onsubmit=' along with the action
    #if ($onsubmit_action) { $onsubmit_action = qq(@{[&$Instrument::show_trace_as_html_comment()]} onsubmit="$onsubmit_action") }
    if ($ez) { $cgi_exe = 'monarch_ez.cgi' }
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form ENCTYPE="multipart/form-data" action="$cgi_dir/$cgi_exe" method=post $onsubmit_action generator=form_top_file>
<table class=data width="90%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td class=data>
<table width="100%" cellpadding=3 cellspacing=0 align=left border=0>
<tr>
<td class=head colspan=3>&nbsp;$caption</td>
</tr>
</table>
</td>
</tr>);
}

sub form_errors(@) {
    my $errors = $_[1];
    my @errors = @{$errors};
    my $errstr = undef;
    foreach my $err (@errors) {
	$errstr .= "$err<br>";
    }
    $errstr =~ s/<br>$//;
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data id="errors">
<script language=JavaScript>
function SetErrorFocus() {
    document.getElementById('errors').scrollIntoView(false);
}
SafeAddOnload(SetErrorFocus);
</script>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=error valign=top width="10%"><b>エラー:</b></td>
<td class=error width="3%">&nbsp;</td>
<td class=error>
下記を訂正してください:<br>
$errstr
</td>
</tr>
</table>
</td>
</tr>);
}

sub profile_import_status(@) {
    my @messages     = @{ $_[1] };
    my $status_table = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<table cellpadding=0 cellspacing=0 align=left border=0>);

    foreach my $message (@messages) {
	if ( $message =~ /^Importing/ ) {
	    $status_table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class colspan=6>$message</td>
</tr><tr>
<td class=$form_class width="35%" align=left>&nbsp;</td>
<td class=$form_class width="13%" align=center>Read</td>
<td class=$form_class width="13%" align=center>Added</td>
<td class=$form_class width="13%" align=center>Updated</td>
<td class=$form_class width="13%" align=center>Overwrite</td>
<td class=$form_class width="13%" align=center>Errors</td>);
	}
	elsif ( $message =~ /^Performance/ ) {
	    $status_table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr><tr>
<td class=$form_class colspan=6>$message</td>);
	}
	elsif ( $message =~ /^-----/ ) {
	    $status_table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr><tr>
<td class=$form_class colspan=6><hr color="#000000"></td>);
	}
	elsif ( $message =~ /^(.*\S+)\s+(\d+)\s*read,\s*(\d+)\s*added,\s*(\d+)\s*updated\s*\(overwrite existing = (Y|N)\S+\)/ ) {
	    $status_table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr><tr>
<td class=$form_class valign=top align=left>$1</td>
<td class=$form_class valign=top align=center>$2</td>
<td class=$form_class valign=top align=center>$3</td>
<td class=$form_class valign=top align=center>$4</td>
<td class=$form_class valign=top align=center>$5</td>);
	}
	elsif (
	    $message =~ /^(.*\S+)\s+(\d+)\s*read,\s*(\d+)\s*added,\s*(\d+)\s*updated,\s*(\d+)\s*error[s]?\s*\(overwrite existing = (Y|N)\S+\)/ )
	{
	    $status_table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr><tr>
<td class=$form_class valign=top align=left>$1</td>
<td class=$form_class valign=top align=center>$2</td>
<td class=$form_class valign=top align=center>$3</td>
<td class=$form_class valign=top align=center>$4</td>
<td class=$form_class valign=top align=center>$6</td>
<td class=$form_class valign=top align=center>$5</td>);
	}
	elsif ( $message =~ /error|try again/i ) {
	    $status_table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr><tr>
<td class=error colspan=6>$message</td>);
	}
	else {
	    $status_table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr><tr>
<td class=$form_class colspan=6>$message</td>);
	}
    }

    $status_table .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
</table>);

    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=wizard_title valign=top>インポートステータス:</td>
</tr>
<tr>
<td class=wizard_body>
<table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
<tr>
<td class=wizard_body>$status_table</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);

}

sub form_message(@) {
    my $title         = $_[1];
    my $message       = $_[2];
    my $class         = $_[3];
    my $color_errors  = $_[4];
    my $simulate_tabs = $_[5];
    my @message       = @{$message};
    # FIX THIS:  make $color_errors a pattern specified by the caller, not a binary flag
    if ($color_errors) {
	foreach (@message) {
	    s@.*@<font color=#CC0000>$&</font>@ if /Error:/;
	}
    }
    if ($simulate_tabs) {
	foreach (@message) {
	    s/^(\t+)/'&nbsp;' x (length($1) * 8)/e;
	}
    }
    my $msg = join( '<br>', @message );
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class="$class" valign=top width="10%">$title</td>
<td class="$class" width="3%">&nbsp;</td>
<td class="$class">
$msg
</td>
</tr>
</table>
</td>
</tr>);
}

sub form_image(@) {
    my $image_file = $_[1];
    my $image_x    = $_[2];
    my $image_y    = $_[3];
    my $class      = $_[4];
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class="$class" align=center>
<img src="$image_file" width="$image_x" height="$image_y">
</td>
</tr>
</table>
</td>
</tr>);
}

sub form_doc(@) {
    my $message = $_[1];
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class valign=top width="100%">
$message
</td>
</tr>
</table>
</td>
</tr>);
}

sub form_status(@) {
    my $title   = $_[1];
    my $message = $_[2];
    my $class   = $_[3];
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class="$class" valign=top width="10%">$title</td>
<td class="$class" colspan=2>
$message
</td>
</tr>
</table>
</td>
</tr>);
}

sub form_bottom_buttons(@) {
    my $self_discard = shift;
    my @args         = @_;
    my $tab          = 0;
    if ( ref( $args[$#args] ) ne 'HASH' ) {
	$tab = pop(@args);
    }
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my $class;
    my $disabled;
    my $html = qq(@{[&$Instrument::show_trace_as_html_comment()]}
    </table>
    <tr>
    <td>
    <table width="100%" cellpadding=0 cellspacing=1 border=0>
    <tr>
    <td style=border:0 align=left>);

    foreach my $button (@args) {
	if (defined $button->{disabled}) {
	    $class = 'submitbutton_disabled';
	    $disabled = 'disabled';
	}
	else {
	    $class = 'submitbutton';
	    $disabled = '';
	}
	$html .= qq(    <input class=$class $disabled type=submit name=$button->{name} value="$button->{value}" onclick="this.form.clicked=this.name" $tabindex>&nbsp;\n);
    }
    unindent($html);

    my $html_end = qq(@{[&$Instrument::show_trace_as_html_comment()]}
    </td>
    </tr>
    </form>
    </table>
    </td>);
    unindent($html_end);

    return $html . $html_end;
}

sub form_file(@) {
    my $tab = $_[1];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class>ファイルをアップロード:
</td>
<td class=$form_class>
<input type=file name=file size=70 maxlength=100 $tabindex>
</td>
</tr>
</table>
</td>
</tr>);
}

sub table_download_links(@) {
    my $doc_folder = $_[1];
    my @source     = @{ $_[2] };
    my $server     = $_[3];
    my $line_url;
    my $plain_url;
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<br><h1>Files in <code>$doc_folder</code></h1>
<table cellpadding=3 cellspacing=0 border=0>\n);
    foreach my $name (@source) {

	if ( $name =~ /tar$/ ) {
	    $line_url  = qq(<a href=$doc_root_monarch/download/$name><b><code>$name</code></b></a>);
	    $plain_url = '';
	}
	else {
	    $line_url =
	      qq(<a href="$cgi_dir/monarch_file.cgi?file=$doc_root_monarch/download/$name" target="_blank"><b><code>$name</code></b></a>);
	    $plain_url = qq(<a href=$doc_root_monarch/download/$name target="_blank"><b><code>(plain)</code></b></a>);
	}
	$detail .= qq(<tr>\n<td>$line_url</td><td>&nbsp;&nbsp;&nbsp;$plain_url\n</td>\n</tr>\n);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>\n);
    return $detail;
}

sub success(@) {
    my $caption   = $_[1];
    my $message   = $_[2];
    my $task      = $_[3];
    my $hidden    = $_[4];
    my %hidden    = %{$hidden};
    my $hiddenstr = undef;
    foreach my $name ( keys %hidden ) {
	unless ( $name =~ /HASH/ ) {
	    $hiddenstr .= "\n<input type=hidden name=$name value=\"$hidden{$name}\">";
	}
    }
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td valign=top>
<table class=form width="75%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=head>$caption</td>
<form action="$cgi_dir/$cgi_exe" generator=success>
$hiddenstr
</tr>
</table>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class>$message</td>
</tr>
</table>
</td>
</tr>
</table>
<tr>
<td>
<table width="100%" cellpadding=0 cellspacing=0 border=0>
<tr>
<td style=border:0 align=left>
<input class=submitbutton type=submit name=$task value="続ける">&nbsp;&nbsp;
</td>
</tr>
</form>
</table>
</td>);
}

sub are_you_sure(@) {
    my $caption = $_[1];
    my $message = $_[2];
    my $task    = $_[3];
    my $hidden  = $_[4];
    my $bail    = $_[5];
    if ( $_[6] ) { $cgi_exe = 'monarch_auto.cgi' }
    my %hidden    = %{$hidden};
    my $hiddenstr = undef;
    unless ($bail) { $bail = 'task' }

    foreach my $name ( keys %hidden ) {
	unless ( $name =~ /HASH/ ) {
	    $hiddenstr .= "\n<input type=hidden name=$name value=\"$hidden{$name}\">";
	}
    }
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td valign=top>
<table class=form width="75%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=head>$caption</td>
<form action="$cgi_dir/$cgi_exe" generator=are_you_sure>
$hiddenstr
</tr>
</table>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class>$message</td>
</tr>
</table>
</table>
<tr>
<td>
<table width="100%" cellpadding=0 cellspacing=0 border=0>
<tr>
<td style=border:0 align=left>
<input class=submitbutton type=submit name=$task value="はい">&nbsp;
<input class=submitbutton type=submit name=$bail value="いいえ">
</td>
</tr>
</form>
</table>
</td>
</tr>
</table>
</td>);
}

sub display($) {
    my $name    = shift;
    my @words   = split( /_/, $name );
    my $display = undef;
    foreach my $word (@words) { $display .= "\u$word " }
    chop $display;
    return $display;
}

sub frame(@) {
    my $session_id = $_[1];
    my $top_menu   = $_[2];
    my $is_portal  = $_[3];
    my $ez         = $_[4];
    my $cols       = 'cols="25%,75%"';
    if ( $top_menu eq 'time_periods' ) {
	$cols = 'cols="18%,82%"';
    }
    if ($is_portal) {
	return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<html>
<head>
<title>Monarch</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<script type="text/javascript" src="/monarch/DataFormValidator.js"></script>
</head>
  <frameset $cols frameborder=yes border=1 framespacing=0>
    <frame name="monarch_left" scrolling=yes src="$cgi_dir/monarch_tree.cgi?CGISESSID=$session_id&top_menu=$top_menu&ez=$ez">
    <frame name="monarch_main" scrolling=yes src="/monarch/blank.html">
  </frameset>
</html>);
    }
    else {
	return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<html>
<head>
<title>Monarch</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<script type="text/javascript" src="/monarch/DataFormValidator.js"></script>
</head>
<frameset rows="65,*" cols="*" frameborder=no border=0 framespacing=0>
  <frame name="monarch_top" scrolling=no noresize src="$cgi_dir/$cgi_exe?update_top=1&CGISESSID=$session_id&top_menu=hosts&ez=$ez&login=1">
  <frameset $cols frameborder=yes border=1 framespacing=0>
    <frame name="monarch_left" scrolling=yes src="$cgi_dir/monarch_tree.cgi?CGISESSID=$session_id&top_menu=hosts&ez=$ez">
    <frame name="monarch_main" scrolling=yes src="/monarch/blank.html">
  </frameset>
</frameset>
</html>);
    }
}

sub top_frame(@) {
    my $session_id = $_[1];
    my $top_menu   = $_[2];
    my @menus      = @{ $_[3] };
    my $auth_level = $_[4];
    my $ver        = $_[5];
    my $enable_ez  = $_[6];
    my $ez         = $_[7];
    my %auth_add   = %{ $_[8] };
    my $login      = $_[9];
    my $title      = "GroundWork Monitor Architect";
    my $class      = 'submenu';
    my $links      = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td align=left>);
    my $colspan    = 2;
    my $menuspan   = 2;
    my $width      = 70;
    my $m          = 0;
    my $first_menu = $menus[0];
    foreach (@menus) { $m++ }
    if ($m) { $width = $width / $m }
    $width = sprintf( "%.0f", $width );
    my $javascript = undef;
    my $ez_main    = undef;
    my %selected   = ();

    if ($ez) {
	$selected{'ez'} = 'selected';
	$javascript = qq(parent.monarch_left.location='$cgi_dir/monarch_tree.cgi?CGISESSID=$session_id&top_menu=$top_menu&ez=1';);
    }
    else {
	$selected{'main'} = 'selected';
	$javascript = qq(parent.monarch_left.location='$cgi_dir/monarch_tree.cgi?CGISESSID=$session_id&top_menu=$top_menu';);
    }
    if ($login) {
	$javascript = undef;
    }    # don't want the page to load twice if new login
    if ( $enable_ez
	&& ( $auth_add{'ez'} || $auth_add{'ez_main'} || $auth_add{'main_ez'} ) )
    {
	$ez_main = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" method=post generator=top_frame>
<input type=hidden name=CGISESSID value=$session_id>
<input type=hidden name=top_menu value=$top_menu>
<input type=hidden name=update_top value=1>
<td class=top align=left width="5%">
<select name=ez onChange="submit()">
<option $selected{'main'} value=0>Main</option>
<option $selected{'ez'} value=1>EZ</option>
</select>
</td>
</form>);
    }
    foreach my $menu (@menus) {
	$colspan++;
	$menuspan++;
	my $display = "\u$menu";
	if ( $menu =~ /_/ ) {
	    $display = undef;
	    my @disp = split( /_/, $menu );
	    foreach (@disp) { $display .= "\u$_ " }
	    chop $display;
	}
	$class = 'top_menu_menu';
	if ( $menu eq 'help' ) {
	    $links .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<a class=top_frame href=$doc_root_monarch/doc/index.html target="_blank">$display</a>);
	}
	else {
	    $links .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<a class=top_frame href=$cgi_dir/monarch_tree.cgi?CGISESSID=$session_id&top_menu=$menu&ez=$ez target="monarch_left" onclick="load_main_frame();">$display</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;);
	}
    }
    $links .= "\n</td>";
    $width = "$width" . "%";
    my $logout = undef;
    if ( $auth_level == 2 ) {
	$colspan--;
	$logout = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=head align=right>
<a class=head href=$cgi_dir/monarch.cgi?CGISESSID=$session_id&view=logout target=_top>Logout</a>
</td>);
    }

    my $detail = qq(
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>@{[&$Instrument::show_trace_as_html_comment()]}
<title>Monarch Menus</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=utf-8">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<link rel="stylesheet" type="text/css" href="$doc_root_monarch/monarch.css">
<SCRIPT language="JavaScript">
	function load_frames() {
		$javascript
		parent.monarch_main.location.href = '/monarch/blank.html';

		return false;
	}
</SCRIPT>
</head>
<body bgcolor="#f0f0f0" onload=load_frames()>
<!-- generated by: MonarchForms::top_frame() -->
<table width="100%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=head colspan=$colspan>&nbsp;<img src=$doc_root_monarch/images/smgwbuttondk.png>&nbsp;&nbsp;$title $ver</td>
$logout
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=3 cellspacing=0 border=0>
<tr>
$ez_main
$links
</tr>
</table>
</td>
</tr>
</body>
</table>
<script type="text/javascript" src="/monarch/DataFormValidator.js"></script>
</html>);
    return $detail;
}

sub header(@) {
    my $title        = $_[1];
    my $session_id   = $_[2];
    my $top_menu     = $_[3];
    my $refresh_url  = $_[4];
    my $refresh_left = $_[5];
    my $ez           = $_[6];
    my $load_event   = $_[7];
    if ( $ez eq '1' ) { $cgi_exe = 'monarch_ez.cgi' }
    if ( $ez eq '2' ) { $cgi_exe = 'monarch_auto.cgi' }
    my $meta = qq(<META HTTP-EQUIV="Expires" CONTENT="-1">);

    if ($refresh_url) {
	$meta = qq(<META HTTP-EQUIV="Refresh" CONTENT="0; URL=$refresh_url">);
    }
    my $javascript = '';
    my $now        = time;
    if ($refresh_left) {
	my $ezstr = undef;
	if ($ez) { $ezstr = '&ez=1' }
	$top_menu =~ s/\s/_/g;    # refresh left time Periods to time_periods
	$top_menu = lc($top_menu);
	$javascript =
"onload=\"parent.monarch_left.location='$cgi_dir/monarch_tree.cgi?CGISESSID=$session_id&nocache=$now&refresh_left=1&top_menu=$top_menu$ezstr';\"";
    }
    if ( defined($load_event) ) {
	if ( $load_event eq '1' ) {
	    $javascript = "onload=\"scan_host();\"";
	}
	elsif ( $load_event eq '2' ) {
	    $javascript = "onload=\"got_error = false; check_status();\"";
	}
    }
    return qq(
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>@{[&$Instrument::show_trace_as_html_comment()]}
<title>$title</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=utf-8">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
$meta
<link rel="stylesheet" type="text/css" href="$doc_root_monarch/monarch.css">
<SCRIPT language=javascript1.1 type="text/javascript" src="$doc_root_monarch/monarch.js"></SCRIPT>
<script src="$doc_root_monarch/nicetitle.js" type="text/javascript"></script>
<script type="text/javascript" src="/monarch/DataFormValidator.js"></script>
</head>
<body bgcolor="#f0f0f0" $javascript>);
}

sub footer(@) {
    my $debug = $_[1];
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
<tr>
<td>
$debug
$extend_page
</td>
</tr>
</table>
</body>
</html>);
}

############################################################################
# Special Forms
#

sub access_checkbox_list(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my @list     = @{ $_[3] };
    my @selected = @{ $_[4] };
    my $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<script language=JavaScript>
function doCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].id == 'asset_checked')
           elements[i].checked = true;
    }
  }
}
function doUnCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].id == 'asset_checked')
           elements[i].checked = false;
    }
  }
}
</script>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%" valign=top>$title</td>
<td class=$form_class>);
    my $got_selected = undef;
    foreach my $item (@list) {
	my $title = $item;
	$title =~ s/_/ /g;
	foreach my $selected (@selected) {
	    if ( $item eq $selected ) { $got_selected = 1 }
	}
	if ($got_selected) {
	    $got_selected = undef;
	    $detail .= "\n<input class=$form_class type=checkbox name=$name id=asset_checked value=\"$item\" checked>&nbsp;\u$title<br>";
	}
	else {
	    $detail .= "\n<input class=$form_class type=checkbox name=$name id=asset_checked value=\"$item\">&nbsp;\u$title<br>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=0 cellspacing=0 align=left border=0>
<tr>
<td>
<input type=submit class=submitbutton name=update_access value="Save">&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェック" onclick=doCheckAll()>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェックを外す" onclick=doUnCheckAll()>&nbsp;&nbsp;
<input type=submit class=submitbutton name=close value="Close">
</td>
</tr>
</form>
</table>
</td>
</tr>);
    return $detail;
}

sub access_settings_ez(@) {
    my %view = %{ $_[1] };
    if ( $view{'enable_ez'} ) { $view{'enable_ez'}       = 'checked' }
    if ( $view{'ez_main'} )   { $view{'ez_main_checked'} = 'checked' }
    if ( $view{'main_ez'} )   { $view{'main_ez_checked'} = 'checked' }
    if ( $view{'ez'} )        { $view{'ez_checked'}      = 'checked' }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%" valign=top>Enable EZ:</td>
<td class=$form_class>
<input class=$form_class type=checkbox name=enable_ez value=enable_ez $view{'enable_ez'}>&nbsp;Enable<br>
</td>
</tr>
<tr>
<td class=top_border width="100%" colspan=5>
<table width="100%" cellpadding=0 cellspacing=0 border=0>
<tr>
<td class=$form_class width="25%" valign=top>ビュー オプション:</td>
<td class=$form_class>
<input class=$form_class type=radio name=ez_view value=ez_main $view{'ez_main_checked'}>&nbsp;EZ-Main<br>
<input class=$form_class type=radio name=ez_view value=main_ez $view{'main_ez_checked'}>&nbsp;Main-EZ<br>
<input class=$form_class type=radio name=ez_view value=ez $view{'ez_checked'}>&nbsp;EZ<br>
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub access_list(@) {
    my $title           = $_[1];
    my $assets          = $_[2];
    my @assets          = @{$assets};
    my $assets_selected = $_[3];
    my %assets_selected = %{$assets_selected};
    my $type            = $_[4];
    my $detail          = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<script language=JavaScript>
function doCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].id == 'asset_checked')
           elements[i].checked = true;
    }
  }
}
function doUnCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].id == 'asset_checked')
           elements[i].checked = false;
    }
  }
}
</script>

<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=row2 align=left>$title</td>
<td class=row2 align=center width="10%">Add</td>
<td class=row2 align=center width="10%">Modify</td>
<td class=row2 align=center width="10%">Delete</td>
<td class=row2 width="20%">&nbsp;</td>
</tr>);

    foreach my $asset (@assets) {
	my %selected = {};
	my @perms = split( /,/, $assets_selected{$asset} );
	foreach (@perms) { $selected{$_} = " checked" }
	my $title = $asset;
	$title =~ s/_/ /g;
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class>\u$title:</td>
<td class=$form_class align=center width="10%">
<input class=$form_class type=checkbox name=$type-add-$asset id=asset_checked value=1$selected{'add'}>
</td>
<td class=$form_class align=center width="10%">
<input class=$form_class type=checkbox name=$type-modify-$asset id=asset_checked value=1$selected{'modify'}>
</td>
<td class=$form_class align=center width="10%">
<input class=$form_class type=checkbox name=$type-delete-$asset id=asset_checked value=1$selected{'delete'}>
</td>
<td class=$form_class width="20%">&nbsp;</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=0 cellspacing=0 align=left border=0>
<tr>
<td>
<input type=submit class=submitbutton name=update_access value="Save">&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェックする" onclick=doCheckAll()>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてのチェックを外す" onclick=doUnCheckAll()>&nbsp;&nbsp;
<input type=submit class=submitbutton name=close value="Close">
</td>
</tr>
</form>
</table>
</td>
</tr>);
    return $detail;
}

sub add_file() {
    my $name     = $_[1];
    my $type     = $_[2];
    my $path     = $_[3];
    my $files    = $_[4];
    my $file     = $_[5];
    my $required = $_[6];
    my $doc      = $_[7];
    if ($required) {
	$required = "<font color=#CC0000>&nbsp;* required</font></td>";
    }

    my @files = @{$files};
    my $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=$form_class align=left width="10%">ファイル:</td>

<td class=$form_class align=left>
<select name=file>);
    if ( !$files[0] ) {
	$detail .= "\n<option selected value=''></option>";
	$detail .= "\n<option value=''>-- チェックコマンドなし --</option>";
    }
    else {
	if ($name) {
	    $detail .= "\n<option value=''></option>";
	}
	else {
	    $detail .= "\n<option selected value=''></option>";
	}
	foreach my $item (@files) {
	    if ( $item eq $name ) {
		$detail .= "\n<option selected value=\"$item\">$item</option>";
	    }
	    else {
		$detail .= "\n<option value=\"$item\">$item</option>";
	    }
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>$required
</td>
<td class=$form_class width="1%">&nbsp;</td>

<tr>
<input type=hidden name=type value=$type>
<td class=$form_class width="10%">&nbsp;</td>
<td class=$form_class>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class align=left width="15%"><input class=submitbutton type=submit name=add_file value="ファイル追加">
<td class=$form_class align=left width="10%">ファイル:</td>
<td class=$form_class align=left width="75%"><input type=text size=60 name=new_file value="$file">$required</td>
</tr>
<tr>
<td class=$form_class align=left width="15%">&nbsp;</td>
<td class=$form_class align=left width="10%">パス:</td>
<td class=$form_class align=left width="75%"><input type=text size=80 name=path value="$path">$required</td>
</tr>
</table>
<td class=$form_class width="1%">&nbsp;</td>
</td>
</tr>
<tr>
<td class=$form_class colspan=3>&nbsp;</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub external_list(@) {
    my $session_id   = $_[1];
    my $name         = $_[2];
    my $externals    = $_[3];
    my $list         = $_[4];
    my $type         = $_[5];
    my $service_id   = $_[6];
    my $service_name = $_[7];
    my $obj_view     = 'host_externals';
    if ( $type eq 'service' ) { $obj_view = 'service_externals' }
    my %externals = %{$externals};
    my @list      = @{$list};
    my $detail    = undef;
    ( my $short_type = $type ) =~ s/_name//;

my $jshort_type = $short_type;
if ($short_type eq 'service') {$jshort_type = 'サービス';}
if ($short_type eq 'host') {$jshort_type = 'ホスト';}

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=$form_class colspan=3>$jshort_type外部設定:</td>
</tr>);
    my $row = 1;
    foreach my $external ( sort keys %externals ) {
	my $class = undef;
	my $removebutton = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $removebutton = 'removebutton_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $removebutton = 'removebutton_dk';
	    $row   = 1;
	}
	if ( $external =~ /HASH/ ) { next }
	my $lexternal = $external;
	$lexternal =~ s/\s/+/g;
	if ( $type eq 'service_name' ) {
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" width="80%" align=left>
$external
</td>);
	}
	else {
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" width="80%" align=left>
<input class="$removebutton" type=submit name=select_external value="$external"><img src=$doc_root_monarch/images/arrow_$class.png border=0>
</td>);
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class="$class" align=center>
<input class="$removebutton" type=submit name=remove_external_$externals{$external} value="削除">
</td>
</tr>);
    }
    my $size = ( scalar @list ) + 1;
    $size = 20 if $size > 20;
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=$form_class colspan=3>
<table width="100%" cellpadding=3 cellspacing=0 border=0>
<tr>
<td class=$form_class width="20%"></td>
<td class=$form_class width="30%" align=center>
<select name=external size=$size>);
    if ( !$list[0] ) {
	$detail .= "\n<option value=''>-- 追加外部設定なし --</option>";
    }
    $detail .= "\n<option selected value=''></option>";
    @list = sort { lc($a) cmp lc($b) } @list;
    foreach my $item (@list) {
	$detail .= "\n<option value=\"$item\">$item</option>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>&nbsp;&nbsp;
</td>
<td class=$form_class align=left><input class=submitbutton type=submit name=external_add value="外部設定追加"></td>
<td class=$form_class width="40%"></td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub external_xml_list(@) {
    my %externals = %{ $_[1] };
    my @externals = @{ $_[2] };
    my $detail    = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);

    foreach my $ext ( sort keys %externals ) {
	if ( $ext =~ /^HASH/ ) { next }
	my $checked = undef;
	if ( $externals{$ext}{'enable'} eq 'ON' ) { $checked = 'checked' }
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="20%" colspan=2><b>$ext</b></td>
<td class=$form_class>Enabled:</td>
<td class=$form_class colspan=4><input type=checkbox name=enabled value=$externals{$ext}{'id'} $checked></td>
</tr>);

	if ( $externals{$ext}{'description'} ) {
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="10%">&nbsp;</td>
<td class=$form_class>Enabled:</td>
<td class=$form_class colspan=5>$externals{$ext}{'description'}</td>
</tr>);

	}
	if ( $externals{$ext}{'service_name'} ) {
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="10%">&nbsp;</td>
<td class=$form_class colspan=4>$externals{$ext}{'service_name'}</td>
</tr>);

	}
	if ( $externals{$ext}{'command'} ) {
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="10%">&nbsp;</td>
<td class=$form_class width="10%">Command:</td>
<td class=$form_class colspan=4>$externals{$ext}{'command'}{'name'}</td>
</tr>);
	    foreach my $param ( sort keys %{ $externals{$ext}{'command'} } ) {
		if ( $param eq 'name' ) { next }
		$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="10%">&nbsp;</td>
<td class=$form_class width="10%">&nbsp;&nbsp;Param:</td>
<td class=$form_class>$param</td>);
		if ( $externals{$ext}{'command'}{$param}{'description'} ) {
		    $detail .=
"\n<td class=$form_class valign=top align=left>\n<a class=orange href='#doc' title=\"$externals{$ext}{'command'}{$param}{'description'}\">&nbsp;?&nbsp;</a>";
		}
		else {
		    $detail .= "</td>\n<td class=$form_class width='3%' align=left>\n&nbsp;</td>";
		}
		$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class><input type=text size=50 name=param_value value="$externals{$ext}{'command'}{$param}{'value'}"></td>
</tr>);
	    }

	}

    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class align=right><input class=submitbutton type=submit name=submit value="外部設定追加">
</td>
<td class=$form_class align=left>
<select name=external size=4 multiple>);
    if ( !$externals[0] ) {
	$detail .= "\n<option value=''>-- 追加する外部設定なし --</option>";
    }
    $detail .= "\n<option selected value=''></option>";
    @externals = sort { lc($a) cmp lc($b) } @externals;
    foreach my $item (@externals) {
	$detail .= "\n<option value=\"$item\">$item</option>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>&nbsp;&nbsp;
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub service_list(@) {
    my $session_id = $_[1];
    my $name       = $_[2];
    my $services   = $_[3];
    my $list       = $_[4];
    my $selected   = $_[5];
    my %services   = %{$services};
    my @list       = @{$list};
    my $now        = time;
    my $detail     = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class colspan=2>サービス名</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=data2>
<table width="100%" cellspacing=0 cellpadding=3 align=left border=0>);
    my $row = 1;
    use URI::Escape;
    $name = uri_escape($name);

    foreach my $service ( sort keys %services ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}
	if ( $service =~ /HASH/ ) { next }
	my $display = $service;
	$display =~ s/\+/ /g;
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" align=left>
<a class=left href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&top_menu=hosts&nocache=$now&selected=$name&view=manage_host&obj=hosts&obj_view=service_detail&name=$name&service_name=$service&service_id=$services{$service}>
$display&nbsp;&middot;&nbsp;詳細&nbsp;<img src=$doc_root_monarch/images/arrow_$class.png border=0></a>
</td>
<td class="$class" align=center>
<a class=left href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&top_menu=hosts&nocache=$now&selected=$name&view=manage_host&obj=hosts&obj_view=services&name=$name&service_id=$services{$service}&submit=remove_service><img src=$doc_root_monarch/images/x_$class.png border=0>&nbsp;サービス割り当ての削除</a>
</td>
</tr>
);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="20%"></td>
<td class=$form_class width="30%" align=right>
<select name=add_service size=15 multiple>);
    if ( !$list[0] ) {
	$detail .= "\n<option value=''>-- 追加サービスなし --</option>";
    }
    $detail .= "\n<option selected value=''></option>";
    @list = sort { lc($a) cmp lc($b) } @list;
    foreach my $item (@list) {
	$detail .= "\n<option value=\"$item\">$item</option>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>&nbsp;&nbsp;
</td>
<td class=$form_class align=left><input class=submitbutton type=submit name=submit value="サービス追加"></td>
<td class=$form_class width="40%" >
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub service_select(@) {
    my $services = $_[1];
    my $selected = $_[2];
    my $tab      = $_[3];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my %services = %{$services};
    my %selected = %{$selected};
    my $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=row2 align=center colspan=3 nowrap>使用 / 変更 / 除外</td>
<td class=row2 align=left>サービス名</td>
<td class=row2 align=left>テンプレート</td>
<td class=row2 align=left>拡張情報</td>
</tr>);
    my $row = 1;

    foreach my $service ( sort keys %services ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}

	if ( $service =~ /HASH/ ) { next }
	my %checked = ();
	if ( $selected{$service} eq 'add' ) {
	    $checked{'add'} = 'checked';
	}
	elsif ( $selected{$service} eq 'edit' ) {
	    $checked{'edit'} = 'checked';
	}
	else {
	    $checked{'discard'} = 'checked';
	}
	my $title = $service;

	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" rowspan=2 align=center width="5%">
<input type=radio class="$class" name="$service" value=add $checked{'add'} $tabindex>
</td>
<td class="$class" rowspan=2 align=center width="5%">
<input type=radio class="$class" name="$service" value=edit $checked{'edit'} $tabindex>
</td>
<td class="$class" rowspan=2 align=center width="5%">
<input type=radio class="$class" name="$service" value=discard $checked{'discard'} $tabindex>
</td>
<td class="$class" align=left>$title
</td>
<td class="$class" align=left>$services{$service}{'template'}
</td>
<td class="$class" align=left>$services{$service}{'extinfo'}
</td>
</tr>
<tr>
<td class="$class" colspan=4 align=left>チェックコマンド: $services{$service}{'command'}
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=row3 colspan=2 align=left>&nbsp;</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub profile_list(@) {
    my $session_id = $_[1];
    my $host       = $_[2];
    my $profiles   = $_[3];
    my @profiles   = @{$profiles};
    my $now        = time;
    my $detail     = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class colspan=2>サービスプロファイル:</td>
</tr>
<tr>
<td class=row_lt>
<table width="100%" cellspacing=0 cellpadding=3 align=left border=0>);
    my $row = 1;

    if ( $profiles[0] ) {
	foreach my $profile (@profiles) {
	    my $class = undef;
	    my $removebutton = undef;
	    if ( $row == 1 ) {
		$class = 'row_lt';
		$removebutton = 'removebutton_lt';
		$row   = 2;
	    }
	    elsif ( $row == 2 ) {
		$class = 'row_dk';
		$removebutton = 'removebutton_dk';
		$row   = 1;
	    }
	    my $display = $profile;
	    $profile = uri_escape($profile);
	    $display =~ s/\+/ /g;
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" align=left>
$display
</td>
<td class="$class" align=center>
<input type=hidden name=profiles value=$profile>
<input class=removebutton type=submit name=remove_$profile value="プロファイル削除" tabindex=-1>
</td>
</tr>
);
	}
    }
    else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=row_lt align=left>
選択されていません
</td>
<td class=row_lt align=center>
&nbsp;
</td>
</tr>
);

    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>
<tr>
<td class=$form_class align=center>&nbsp;</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub add_service_profile(@) {
    my $list     = $_[1];
    my $tab      = $_[2];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my @list     = @{$list};
    my $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class colspan=3 width="25%" align=center>サービスプロファイル選択:
</td>
<td class=$form_class colspan=4 rowspan=2 valign=top align=left>
<select name=profiles $tabindex>);
    if ( !$list[0] ) {
	$detail .= "\n<option value=''>-- 追加サービスプロファイルなし --</option>";
    }
    $detail .= "\n<option selected value=''></option>";
    @list = sort { lc($a) cmp lc($b) } @list;
    foreach my $item (@list) {
	$detail .= "\n<option value=\"$item\">$item</option>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>&nbsp;&nbsp;
</td>
</tr>
<tr>
<td class=$form_class colspan=3 width="25%" align=center><input class=submitbutton type=submit name=add_profile value="プロファイルの追加" $tabindex>
</td>
</tr>
<tr>
<td class=row3 colspan=2 align=left>&nbsp;</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub add_service(@) {
    my $list     = $_[1];
    my $tab      = $_[2];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my @list     = @{$list};
    my $size     = ( scalar @list ) + 1;
# original (2014.5.28)    $size = 20 if $size > 20;
    $size = 10 if $size > 10;
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class colspan=3 width="25%" align=center>その他のサービス選択:
</td>
<td class=$form_class colspan=4 rowspan=2 valign=top align=left>
<select name=services size=$size multiple $tabindex>);

    if ( !$list[0] ) {
	$detail .= "\n<option value=''>-- 追加サービスなし --</option>";
    }
    $detail .= "\n<option selected value=''></option>";
    @list = sort { lc($a) cmp lc($b) } @list;
    foreach my $item (@list) {
	$detail .= "\n<option value=\"$item\">$item</option>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>&nbsp;&nbsp;
</td>
</tr>
<tr>
<td class=$form_class colspan=3 width="25%" align=center><input class=submitbutton type=submit name=add_service value="リストへの追加" $tabindex>
</td>
</tr>
<tr>
<td class=row3 colspan=2 align=left>&nbsp;</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub manage_escalation_tree(@) {
    my $session_id     = $_[1];
    my $view           = $_[2];
    my $type           = $_[3];
    my $name           = $_[4];
    my $tree_id        = $_[5];
    my $ids            = $_[6];
    my $members        = $_[7];
    my $nonmembers     = $_[8];
    my $contact_groups = $_[9];
    my $first_notify   = $_[10];
    my $tab            = $_[11];
    my $tabindex       = $tab ? "tabindex=\"$tab\"" : '';
    my @members        = @{$members};
    my @nonmembers     = @{$nonmembers};
    @nonmembers = sort { lc($a) cmp lc($b) } @nonmembers;
    my %ids            = %{$ids};
    my %contact_groups = %{$contact_groups};
    my %first_notify   = %{$first_notify};
    my $errstr         = undef;
    my $now            = time;
    my $detail         = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="40%" colspan=2 align=left>
<table class=form cellspacing=1 cellpadding=3 width="100%" align=left border=0>
<tr>
<td class=row2>エスカレーション</td>
<td class=row2>通知開始</td>
<td class=row2>通知先グループ</td>
<td class=row2 colspan=2>&nbsp;</td>
</tr>);

    foreach my $escalation (@members) {
	my $sname = $name;
	$sname =~ s/\s/+/g;
	my $fn = $first_notify{ $ids{$escalation} };
	$fn =~ s/-zero-/0/;
	my $contactgroups = $contact_groups{ $ids{$escalation} } || '<font color=#CC0000>エラー: まだアサインされていません</font>';
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=row_dk valign=top>
$escalation
</td>
<td class=row_dk valign=top>
$fn
</td>
<td class=row_dk>$contactgroups
</td>
<td class=row_dk align=center valign=top>
<input type=submit class=escbutton name=assign_contact_group_$ids{$escalation} value="通知先グループの変更" $tabindex>
</td>
<td class=row_dk align=center valign=top>
<input type=submit class=escbutton name=remove_escalation_$ids{$escalation} value="エスカレーションの削除" $tabindex>
</td>
</tr>);
    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class colspan=5>
<table width="100%" cellpadding=0 cellspacing=0 border=0>
<tr>
<td class=$form_class width="20%" valign=top align=left>このエスカレーションに追加可能なエスカレーション:
</td>
<td class=$form_class valign=top align=center>
<select name=escalation size=10 $tabindex>);
    my $options = undef;
    $detail .= "\n<option selected value=''></option>";
    foreach my $nmem (@nonmembers) {
	my $got_mem = undef;
	foreach my $mem (@members) {
	    if ( $nmem eq $mem ) { $got_mem = 1 }
	}
	if ($got_mem) {
	    $got_mem = undef;
	    next;
	}
	else {
	    $options .= "\n<option value=\"$nmem\">$nmem</option>";
	}
    }
    if ( !$options ) {
	$options = "\n<option value=''>-- エスカレーションなし --</option>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
$options
</select>&nbsp;&nbsp;
</td>
<td class=$form_class width="55%" align=left><input class=submitbutton type=submit name=add_escalation value="エスカレーション追加" $tabindex>
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);
}

sub host_top(@) {
    my $name         = $_[1];
    my $session_id   = $_[2];
    my $obj_view     = $_[3];
    my $externals    = $_[4];
    my $selected     = $_[5];
    my $form_service = $_[6];
    my $boxwidth     = ($obj_view eq 'service_check' || $obj_view =~ /_external_detail/) ? '100%' : '90%';
    my $now          = time;
    my $colspan      = 1;
    my @menus        = ();
#
#  ADD for simple monarch 2014.5.26
#
          my %pp = StorProc->fetch_one( 'setup', 'name', 'enable_detail_conf' );
          my $edc = $pp{'value'};
#
    if ($form_service) {
      if ($edc){
	@menus   = ( 'service_detail', 'service_check', 'service_dependencies' );
	if ($externals) {
	    push @menus, 'service_externals';
	}
	if ( $obj_view eq 'service_external_detail' ) {
	    push @menus, 'service_external_detail';
	}
      } else {
       @menus   = ( 'service_detail', 'service_check' );
      }
    }
    else {
	push @menus, 'host_detail';
	if ( $obj_view =~ /service_detail|service_dependencies|service_externals|service_check/ ) {
#
#  Chenged for simple monarch 2014.5.26
#
          if ($edc) {
	    push( @menus, ( 'services', 'service_detail', 'service_check', 'service_dependencies' ) );
	    if ($externals) {
		push @menus, 'service_externals';
	    }
          } else {
            push( @menus, ( 'services', 'service_detail', 'service_check' ) );
          }
	}
	elsif ( $obj_view eq 'service_external_detail' ) {
	    push( @menus, ( 'services', 'service_detail', 'service_externals', 'service_external_detail' ) );
	}
	elsif ( $obj_view eq 'host_external_detail' ) {
	    push( @menus, ( 'profile', 'services', 'host_externals', 'host_external_detail' ) );
	}
	else {
#
#  Chenged for simple monarch 2014.5.26
#
          if ($edc) {
	    push( @menus, ( 'profile', 'parents', 'hostgroups', 'escalation_trees', 'services' ) );
	    if ($externals) {
		push @menus, 'host_externals';
	    }
          } else {
	    push( @menus, ( 'profile', 'parents', 'hostgroups', 'services' ) );
          }
	}
    }
    $colspan = scalar (@menus);
    my $width = 100 / $colspan . '%';
    my $title = 'ホスト管理';
    if ($form_service) { $title .= ' サービス' }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td valign=top align=left>);

    if ( $obj_view =~ /profile|parents|hostgroups|host_detail|service_detail/ ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" onsubmit="selIt();" method=post generator=host_top1>);
    }
    else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" method=post generator=host_top2>);
    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<table width="$boxwidth" cellpadding=0 cellspacing=1 border=0>
<tr>
<td>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=head colspan=$colspan>&nbsp;$title</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);

    my $class      = undef;
    my $bclass     = undef;
    my @lmenus     = @menus;
    my $last_menu  = pop @lmenus;
    my $first_menu = $menus[0];
    foreach my $view (@menus) {
	if ( $obj_view eq $view ) {
	    $class  = 'top_menu_selected';
	    $bclass = 'topbuttonselected';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_selected_right';
	    }
	    if ( $view eq $first_menu ) {
		$class = 'top_menu_selected_left';
	    }
	}
	else {
	    $class  = 'top_menu_menu';
	    $bclass = 'topbutton';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_right';
	    }
	}
	my $menu = $view;
	$menu = undef;
	my @menu = split( /_/, $view );
	foreach (@menu) { $menu .= "\u$_ " }
	chop $menu;
if ($menu eq 'Host Detail'){ $menu = "ホスト詳細"; }
if ($menu eq 'Profile'){ $menu = "プロファイル"; }
if ($menu eq 'Parents'){ $menu = "親子関係"; }
if ($menu eq 'Hostgroups'){ $menu = "ホストグループ"; }
if ($menu eq 'Escalation Trees'){ $menu = "エスカレーションツリー"; }
if ($menu eq 'Services'){ $menu = "サービス"; }
if ($menu eq 'Service Detail'){ $menu = "サービス詳細"; }
if ($menu eq 'Service Check'){ $menu = "サービスチェック"; }
if ($menu eq 'Service Dependencies'){ $menu = "サービス依存"; }
if ($menu eq 'Host Externals'){ $menu = "外部設定"; }
if ($menu eq 'Service Externals'){$menu ="サービス外部設定"}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class="$class" width="$width" align=center>
<input type=submit class=$bclass name=$view value="$menu">
</td>);
    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
<tr>
<td class=top_menu_selected_bar colspan=$colspan>&nbsp;</td>
</tr>
</table>
<tr>
<td class=data >
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%">ホスト名:</td>
<td class=$form_class width="3%">&nbsp;</td>
<td class=$form_class>$name<input type=hidden name=name value="$name"></td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub host_profile_top(@) {
    my $name       = $_[1];
    my $session_id = $_[2];
    my $obj_view   = $_[3];
    my $externals  = $_[4];
    my $objs       = $_[5];
    my %objs       = ();
    my $urlstr     = undef;
    my $now        = time;
# add 2014.05.30
  my %pp = StorProc->fetch_one( 'setup', 'name', 'enable_detail_conf' );
  my $edc = $pp{'value'};
#
    if ($objs) {
	%objs = %{$objs};
	foreach my $key ( keys %objs ) {
	    if ( $objs{$key} ) { $urlstr .= '&' . $key . '=' . $objs{$key} }
	}
    }
    my $colspan = 9;
    my @menus = undef;
#
  if ($edc) {
    @menus = ( 'host_detail', 'parents', 'hostgroups', 'escalation_trees' );
    if ($externals) {
	push( @menus, ( 'externals', 'service_profiles', 'assign_hosts', 'assign_hostgroups', 'apply' ) );
	$colspan = 10;
    }
    else {
	push( @menus, ( 'service_profiles', 'assign_hosts', 'assign_hostgroups', 'apply' ) );
    }
#
  } else { 
    @menus = ( 'host_detail', 'parents', 'hostgroups', 'service_profiles', 'assign_hosts', 'assign_hostgroups', 'apply' );
  }

    my $width  = 100 / $colspan . '%';
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td valign=top align=left>
<table width="90%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=head colspan=$colspan>&nbsp;ホストプロファイル</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);
    my $class      = undef;
    my @lmenus     = @menus;
    my $last_menu  = pop @lmenus;
    my $first_menu = $menus[0];

    foreach my $view (@menus) {
	if ( $obj_view eq $view ) {
	    $class = 'top_menu_selected';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_selected_right';
	    }
	    if ( $view eq $first_menu ) {
		$class = 'top_menu_selected_left';
	    }
	}
	else {
	    $class = 'top_menu_menu';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_right';
	    }
	}
	my $menu = $view;
	$menu = undef;
	my @menu = split( /_/, $view );
	foreach (@menu) { $menu .= "\u$_ " }
	my $cname = $name;
	$cname =~ s/\s/+/g;
	chop $menu;
if ($menu eq 'Host Detail'){ $menu = "ホスト詳細"; }
if ($menu eq 'Parents'){ $menu = "親子関係"; }
if ($menu eq 'Hostgroups'){ $menu = "ホストグループ"; }
if ($menu eq 'Escalation Trees'){ $menu = "エスカレーションツリー"; }
if ($menu eq 'Service Profiles'){ $menu = "サービスプロファイル"; }
if ($menu eq 'Externals'){ $menu = "外部設定"; }
if ($menu eq 'Assign Hosts'){ $menu = "ホストの割り当て"; }
if ($menu eq 'Assign Hostgroups'){ $menu = "ホストグループの割り当て"; }
if ($menu eq 'Apply'){ $menu = "適用"; }
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class="$class" width="$width" align=center>
<a class=top href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&top_menu=profiles&nocache=$now&view=host_profile&obj_view=$view&name=$cname$urlstr>\u$menu</a>
</td>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
<tr>
<td class=top_menu_selected_bar colspan=$colspan>&nbsp;</td>
</tr>);
    if ( $obj_view =~ /parents|host|externals|service_profiles/ ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" onsubmit="selIt();" method=post generator=host_profile_top1>);
    }
    else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" method=post generator=host_profile_top2>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
</table>
</td>
</tr>
<tr>
<td class=data colspan=$colspan>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="30%">ホストプロファイル名:</td>
<input type=hidden name=name value="$name">
<td class=$form_class>$name</td>
</tr>
</table>
</td>
</tr>);

    return $detail;
}

sub apply_select() {
    my $view       = $_[1];
    my $selected   = $_[2];
    my $nagios_ver = $_[3];
    my $tab        = $_[4];
    my $tabindex   = $tab ? "tabindex=\"$tab\"" : '';
    my %selected   = %{$selected};
#
    my %pp = StorProc->fetch_one( 'setup', 'name', 'enable_detail_conf' );
    my $edc = $pp{'value'};

    my $detail     = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class align=left colspan=2 style="height: 0.5em"></td>
</tr>);

    unless ( $view =~ /service$|manage_host/ ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class align=right width="30%">ホストグループアクション:</td>
<td class=$form_class align=left colspan=2>
<input class=$form_class type=checkbox name=hostgroups_select $selected{'hostgroups_select'} $tabindex>&nbsp;ホストグループへ適用.
</td>
</tr>
<tr>
<td class=$form_class align=right width="30%">ホストアクション:</td>
<td class=$form_class align=left>
<input class=$form_class type=checkbox name=hosts_select $selected{'hosts_select'} $tabindex>&nbsp;ホストへ適用.
</td>
</tr>
<tr>
<td class=$form_class align=left colspan=2><hr></td>
</tr>);
    }

    if ( $view =~ /host_profile/ ) {
if ($edc) { 
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class align=right width="30%">ホストプロパティー:</td>
<td class=$form_class align=left>
<input type=checkbox class=radio name=apply_parents $selected{'apply_parents'} $tabindex>&nbsp;親ホストをホストへ適用.
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input type=checkbox class=radio name=apply_hostgroups value=replace $selected{'apply_hostgroups'} $tabindex>&nbsp;ホストグループをホストへ適用.
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input type=checkbox class=radio name=apply_escalations $selected{'apply_escalations'} $tabindex>&nbsp;エスカレーションをホストへ適用.
</td>
</tr>);
} else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class align=right width="30%">ホストプロパティー:</td>
<td class=$form_class align=left>
<input type=checkbox class=radio name=apply_parents $selected{'apply_parents'} $tabindex>&nbsp;親ホストをホストへ適用.
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input type=checkbox class=radio name=apply_hostgroups value=replace $selected{'apply_hostgroups'} $tabindex>&nbsp;ホストグループをホストへ適用.
</td>
</tr>);
}
	if ( $nagios_ver =~ /^[23]\.x$/ ) {
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input type=checkbox class=radio name=apply_contactgroups $selected{'apply_contactgroups'} $tabindex>&nbsp;通知先グループをホストへ適用.
</td>
</tr>);
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input type=checkbox class=radio name=apply_detail $selected{'apply_detail'} $tabindex>&nbsp;詳細をホストへ適用.
</td>
</tr>
<tr>
<td class=$form_class align=left colspan=2><hr></td>
</tr>);
    }
    if ( $view eq 'service' ) {
	if ( $selected{'apply_services'} eq 'replace' ) {
	    $selected{'replace'} = 'checked';
	}
	else {
	    $selected{'merge'} = 'checked';
	}

if ($edc) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class align=right width="30%">サービス設定アクション:</td>
<td class=$form_class align=left>
<input class=$form_class type=checkbox name=apply_check $selected{'apply_check'} $tabindex>&nbsp;サービスチェックを適用する
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input class=$form_class type=checkbox name=apply_contact_service $selected{'apply_contact_service'} $tabindex>&nbsp;通知先グループを適用する
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input class=$form_class type=checkbox name=apply_extinfo_service $selected{'apply_extinfo_service'} $tabindex>&nbsp;サービス拡張情報を適用する
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input class=$form_class type=checkbox name=apply_escalation_service $selected{'apply_escalation_service'} $tabindex>&nbsp;サービスエスカレーションを適用する
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input class=$form_class type=checkbox name=apply_dependencies $selected{'apply_dependencies'} $tabindex>&nbsp;依存関係を適用する
</td>
</tr>
<tr>
<td class=$form_class align=left colspan=2><hr></td>
</tr>
<tr>
<td class=$form_class align=right width="30%">ホストサービスアクション:</td>
<td class=$form_class align=left>
<input type=radio class=radio name=apply_services value=replace $selected{'replace'} $tabindex>&nbsp;既存のサービスプロパティを置き換える（強制的な継承）.
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input type=radio class=radio name=apply_services value=merge $selected{'merge'} $tabindex>&nbsp;既存のサービスプロパティとマージする（上書き保存）.
</td>
</tr>);
} else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class align=right width="30%">サービス設定アクション:</td>
<td class=$form_class align=left>
<input class=$form_class type=checkbox name=apply_check $selected{'apply_check'} $tabindex>&nbsp;サービスチェックを適用する
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input class=$form_class type=checkbox name=apply_contact_service $selected{'apply_contact_service'} $tabindex>&nbsp;通知先グループを適用する
</td>
</tr>
<tr>
<td class=$form_class align=left colspan=2><hr></td>
</tr>
<tr>
<td class=$form_class align=right width="30%">ホストサービスアクション:</td>
<td class=$form_class align=left>
<input type=radio class=radio name=apply_services value=replace $selected{'replace'} $tabindex>&nbsp;既存のサービスプロパティを置き換える（強制的な継承）
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input type=radio class=radio name=apply_services value=merge $selected{'merge'} $tabindex>&nbsp;既存のサービスプロパティとマージする（上書き保存）
</td>
</tr>);


}
    }
    unless ( $view eq 'service' ) {
	if ( $selected{'apply_services'} eq 'replace' ) {
	    $selected{'replace'} = 'checked';
	}
	else {
	    $selected{'merge'} = 'checked';
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class align=right width="30%">サービスアクション:</td>
<td class=$form_class align=left>
<input type=radio class=radio name=apply_services value=replace $selected{'replace'} $tabindex>&nbsp;既存のサービスと置き換える.
</td>
</tr>
<tr>
<td class=$form_class align=left width="30%">&nbsp;</td>
<td class=$form_class align=left>
<input type=radio class=radio name=apply_services value=merge $selected{'merge'} $tabindex>&nbsp;既存のサービスとマージする.
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class align=left colspan=2 style="height: 0.9em"></td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub service_template_top(@) {
    my $name       = $_[1];
    my $session_id = $_[2];
    my $obj_view   = $_[3];
    my $objs       = $_[4];
    my $selected   = $_[5];
    my $boxwidth   = ($obj_view eq 'service_check') ? '100%' : '90%';
    my %objs       = ();
    my $urlstr     = undef;
    my $now        = time;
    if ($objs) {
	%objs = %{$objs};
	foreach my $key ( keys %objs ) {
	    if ( $objs{$key} ) { $urlstr .= '&' . $key . '=' . $objs{$key} }
	}
    }
    my $colspan = 3;
    $urlstr =~ s/ /+/g;
    my @menus = ( 'service_detail', 'service_check' );

    my $width  = 100 / $colspan . '%';
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td valign=top align=left>
<table width="$boxwidth" cellpadding=0 cellspacing=1 border=0>
<tr>
<td colspan=3>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=head>&nbsp;サービス管理テンプレート</td>
</tr>
</table>
</td>
</tr>
<tr>
<td colspan=3>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);
    my $class      = undef;
    my @lmenus     = @menus;
    my $last_menu  = pop @lmenus;
    my $first_menu = $menus[0];
    foreach my $view (@menus) {
	if ( $obj_view eq $view ) {
	    $class = 'top_menu_selected';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_selected_right';
	    }
	    if ( $view eq $first_menu ) {
		$class = 'top_menu_selected_left';
	    }
	}
	else {
	    $class = 'top_menu_menu';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_right';
	    }
	}
	my $menu = $view;
	$menu = undef;
	my @menu = split( /_/, $view );
	foreach (@menu) { $menu .= "\u$_ " }
	chop $menu;
if ($menu eq 'Service Detail'){ $menu = "サービス詳細"; }
if ($menu eq 'Service Check'){ $menu = "サービスチェック"; }
	my $ename = uri_escape($name);
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class="$class" width="15%" align=center>
<a class=top href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&nocache=$now&top_menu=services&selected=$selected&view=service_template&obj=service_templates&obj_view=$view&name=$ename$urlstr>\u$menu</a>
</td>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=top_menu_fill>&nbsp;</td>
</tr>
<tr>
<td class=top_menu_selected_bar colspan=3>&nbsp;</td>
</tr>
</table>);
    if ( $obj_view =~ /service_detail|service_profiles/ ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" onsubmit="selIt();" method=post generator=service_template_top1>);
    }
    else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" method=post generator=service_template_top2>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
<tr>
<td class=data colspan=$colspan>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%">サービステンプレート名:</td>
<td class=$form_class width="3%">&nbsp;</td>
<td class=$form_class>$name</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub service_top(@) {
    my $name       = $_[1];
    my $session_id = $_[2];
    my $obj_view   = $_[3];
    my $objs       = $_[4];
    my $externals  = $_[5];
    my $selected   = $_[6];
    my $host_id    = $_[7];
    my $boxwidth   = ($obj_view eq 'service_check') ? '100%' : '90%';
    my %objs       = ();
    my $urlstr     = undef;
    my $now        = time;
    if ($objs) {
	%objs = %{$objs};
	foreach my $key ( keys %objs ) {
	    if ( $objs{$key} ) { $urlstr .= '&' . $key . '=' . $objs{$key} }
	}
    }
    my $colspan = 5;
    $urlstr =~ s/ /+/g;
#    
    my @menus = undef;
    my %pp = StorProc->fetch_one( 'setup', 'name', 'enable_detail_conf' );
    my $edc = $pp{'value'};
    if ($edc) {
#
    @menus = ( 'service_detail', 'service_check', 'service_dependencies' );
    unless ($host_id)   { push @menus, 'service_profiles' }
    if     ($externals) { push @menus, 'service_externals'; $colspan = 6; }
    unless ($host_id)   { push @menus, 'apply_hosts' }
#
    } else {
    @menus = ( 'service_detail', 'service_check' );
    unless ($host_id)   { push @menus, 'service_profiles' ; push @menus, 'apply_hosts';}    
    }
    my $width  = 100 / $colspan . '%';
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td valign=top align=left>
<table width="$boxwidth" cellpadding=0 cellspacing=1 border=0>
<tr>
<td>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=head colspan=$colspan>&nbsp;サービス管理</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);
    my $class      = undef;
    my @lmenus     = @menus;
    my $last_menu  = pop @lmenus;
    my $first_menu = $menus[0];
    foreach my $view (@menus) {
	if ( $obj_view eq $view ) {
	    $class = 'top_menu_selected';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_selected_right';
	    }
	    if ( $view eq $first_menu ) {
		$class = 'top_menu_selected_left';
	    }
	}
	else {
	    $class = 'top_menu_menu';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_right';
	    }
	}
	my $menu = $view;
	$menu = undef;
	my @menu = split( /_/, $view );
	foreach (@menu) { $menu .= "\u$_ " }
	chop $menu;
	my $ename = $name;
	$ename = uri_escape($ename);
if ($menu eq 'Service Detail'){ $menu = "サービス詳細"; }
if ($menu eq 'Service Check'){ $menu = "サービスチェック"; }
if ($menu eq 'Service Dependencies'){ $menu = "サービス依存関係"; }
if ($menu eq 'Service Profiles'){ $menu = "サービスプロファイル"; }
if ($menu eq 'Service Externals'){ $menu = "外部設定"; }
if ($menu eq 'Apply Hosts'){ $menu = "ホストの適用"; }
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class="$class" width="$width" align=center>
<a class=top href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&nocache=$now&top_menu=services&selected=$selected&view=service&obj=services&obj_view=$view&name=$ename&host_id=$host_id$urlstr>\u$menu</a>
</td>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
<tr>
<td class=top_menu_selected_bar colspan=$colspan>&nbsp;</td>
</tr>
</table>);
    if ( $obj_view =~ /service_detail|service_profiles/ ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" onsubmit="selIt();" method=post generator=service_top1>);
    }
    else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" method=post generator=service_top2>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data colspan=$colspan>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%">サービス名:</td>
<td class=$form_class width="3%">&nbsp;</td>
<td class=$form_class>$name</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub service_profile_top(@) {
    my $name       = $_[1];
    my $session_id = $_[2];
    my $obj_view   = $_[3];
    my $objs       = $_[4];
    my $selected   = $_[5];
    my %objs       = ();
    my $urlstr     = undef;
    my $now        = time;
    if ($objs) {
	%objs = %{$objs};
	foreach my $key ( keys %objs ) {
	    if ( $objs{$key} ) { $urlstr .= '&' . $key . '=' . $objs{$key} }
	}
    }
    my $colspan = 5;
    $urlstr =~ s/ /+/g;
    my @menus  = ( 'services', 'assign_hosts', 'assign_hostgroups', 'host_profiles', 'apply' );
    my $width  = 100 / $colspan . '%';
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td valign=top align=left>
<table width="90%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=head colspan=$colspan>&nbsp;サービスプロファイル</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);
    my $class      = undef;
    my @lmenus     = @menus;
    my $last_menu  = pop @lmenus;
    my $first_menu = $menus[0];

    foreach my $view (@menus) {
	if ( $obj_view eq $view ) {
	    $class = 'top_menu_selected';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_selected_right';
	    }
	    if ( $view eq $first_menu ) {
		$class = 'top_menu_selected_left';
	    }
	}
	else {
	    $class = 'top_menu_menu';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_right';
	    }
	}
	my $menu = $view;
	$menu = undef;
	my @menu = split( /_/, $view );
	foreach (@menu) { $menu .= "\u$_ " }
	my $ename = $name;
	$ename = uri_escape($ename);
	chop $menu;
if ($menu eq 'Services'){ $menu = "サービス"; }
if ($menu eq 'Assign Hosts'){ $menu = "ホストの割り当て"; }
if ($menu eq 'Assign Hostgroups'){ $menu = "ホストグループの割り当て"; }
if ($menu eq 'Host Profiles'){ $menu = "ホストプロファイル"; }
if ($menu eq 'Apply'){ $menu = "適用"; }
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class="$class" width="$width" align=center>
<a class=top href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&top_menu=profiles&nocache=$now&selected=$selected&view=service_profile&obj=profile&obj_view=$view&name=$ename$urlstr>\u$menu</a>
</td>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
<tr>
<td class=top_menu_selected_bar colspan=$colspan>&nbsp;</td>
</tr>
</table>);
    if ( $obj_view =~ /services|assign_hosts|assign_hostgroups|host_profiles/ ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" onsubmit="selIt();" method=post generator=service_profile_top1>);
    }
    else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" method=post generator=service_profile_top2>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data colspan=$colspan>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%">サービスプロファイル名:</td>
<td class=$form_class width="3%">&nbsp;</td>
<input type=hidden name=name value="$name">
<td class=$form_class>$name</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub group_top(@) {
    my $name     = $_[1];
    my $obj_view = $_[2];
    my $now      = time;
    my $colspan  = 4;
    my @menus    = ( 'detail', 'hosts', 'sub_groups', 'macros' );

    my $width  = '25%';
    my $title  = 'グループ管理';
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td valign=top align=left>
<table width="90%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=head colspan=$colspan>&nbsp;$title</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);
    if ( $obj_view =~ /detail|hosts/ ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" onsubmit="selIt();" method=post generator=group_top1>);
    }
    else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" method=post generator=group_top2>);
    }
    my $class      = undef;
    my $bclass     = undef;
    my @lmenus     = @menus;
    my $last_menu  = pop @lmenus;
    my $first_menu = $menus[0];
    foreach my $view (@menus) {
	if ( $obj_view eq $view ) {
	    $class  = 'top_menu_selected';
	    $bclass = 'topbuttonselected';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_selected_right';
	    }
	    if ( $view eq $first_menu ) {
		$class = 'top_menu_selected_left';
	    }
	}
	else {
	    $class  = 'top_menu_menu';
	    $bclass = 'topbutton';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_right';
	    }
	}
	my $menu = $view;
	$menu = undef;
	my @menu = split( /_/, $view );
	foreach (@menu) { $menu .= "\u$_ " }
	chop $menu;
if ($menu eq 'Detail'){ $menu = "詳細"; }
if ($menu eq 'Hosts'){ $menu = "ホスト"; }
if ($menu eq 'Sub Groups'){ $menu = "サブグループ"; }
if ($menu eq 'Macros'){ $menu = "マクロ"; }
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class="$class" width="$width" align=center>
<input type=submit class=$bclass name=$view value="$menu">
</td>);
    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
<tr>
<td class=top_menu_selected_bar colspan=$colspan>&nbsp;</td>
</tr>
</table>
<tr>
<td class=data colspan=$colspan>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%">Monarch グループ名:</td>
<td class=$form_class width="3%">&nbsp;</td>
<td class=$form_class>$name</td>
<input type=hidden name=name value="$name">
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub access_top(@) {
    my $groupid    = $_[1];
    my $session_id = $_[2];
    my $obj_view   = $_[3];
    my @menus      = @{ $_[4] };
    my $urlstr     = undef;
    my $now        = time;
    my $detail     = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td valign=top align=left>
<table class width="75%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=head>Access Values User Group: $groupid</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);
    my $class = undef;

    foreach my $view (@menus) {
	if ( $obj_view eq $view ) {
	    $class = 'top_menu_selected';
	}
	else {
	    $class = 'top_menu_menu';
	}
	my $menu = $view;
	$menu = undef;
	my @menu = split( /_/, $view );
	foreach (@menu) { $menu .= "\u$_ " }
	chop $menu;
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class="$class" align=center>
<a class=top href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&top_menu=control&nocache=$now&view=control&obj=user_groups&groupid=$groupid&access_set=$view>\u$menu</a>
</td>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
</table>
</td>
</tr>
<form name=form action="$cgi_dir/$cgi_exe" method=post generator=access_top>);
    return $detail;
}

sub escalation_top() {
    my $name       = $_[1];
    my $session_id = $_[2];
    my $obj_view   = $_[3];
    my $type       = $_[4];
    my $nagios_ver = $_[5];
    my $colspan    = 4;
    my @menus      = ('detail');
    if ( $obj_view eq 'assign_contact_groups' ) {
	push @menus, 'assign_contact_groups';
    }
    else {
	push( @menus, ( 'assign_hostgroups', 'assign_hosts' ) );
	if ( $type eq 'service' ) {
	    if ( $nagios_ver =~ /^[23]\.x$/ ) {
		push( @menus, ( 'assign_service_groups', 'assign_services' ) );
		$colspan = 5;
	    }
	    else {
		push @menus, 'assign_services';
		$colspan = 4;
	    }
	}
    }
    my $width  = 100 / $colspan . '%';
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td valign=top align=left>
<table width="90%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td>
<table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
<tr>
<td class=head colspan=$colspan>&nbsp;エスカレーションツリー</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>);
    my $class      = undef;
    my $bclass     = undef;
    my @lmenus     = @menus;
    my $last_menu  = pop @lmenus;
    my $first_menu = $menus[0];
    my $menu_str   = undef;

    foreach my $view (@menus) {
	if ( $obj_view eq $view ) {
	    $class  = 'top_menu_selected';
	    $bclass = 'topbuttonselected';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_selected_right';
	    }
	    if ( $view eq $first_menu ) {
		$class = 'top_menu_selected_left';
	    }
	}
	else {
	    $class  = 'top_menu_menu';
	    $bclass = 'topbutton';
	    if ( $view eq $last_menu ) {
		$class = 'top_menu_right';
	    }
	}
	my $menu = $view;
	$menu = undef;
	my @menu = split( /_/, $view );
	foreach (@menu) { $menu .= "\u$_ " }
	chop $menu;
if ($menu eq 'Detail'){ $menu = "詳細"; }
if ($menu eq 'Assign Contact Groups'){ $menu = "通知先グループの割り当て"; }
if ($menu eq 'Assign Hostgroups'){ $menu = "ホストグループの割り当て"; }
if ($menu eq 'Assign Hosts'){ $menu = "ホストの割り当て"; }
if ($menu eq 'Assign Service Groups'){ $menu = "サービスグループの割り当て"; }
if ($menu eq 'Assign Services'){ $menu = "サービスの割り当て"; }
if ($menu eq 'Assign Contactgroups'){ $menu = "通知先グループの割り当て"; }
	$menu_str .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class="$class" width="$width" align=center>
<input type=submit class=$bclass name=$view value="$menu">
</td>);
    }
    $menu_str .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
<tr>
<td class=top_menu_selected_bar colspan=$colspan>&nbsp;</td>
</tr>);
    unless ( $obj_view =~ /detail/ ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" onsubmit="selIt();" method=post generator=escalation_top1>);
    }
    else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<form name=form action="$cgi_dir/$cgi_exe" method=post generator=escalation_top2>);
    }

my $jtype = $type;
if ($type eq 'service'){ $jtype = "サービス"; }
if ($type eq 'host'){ $jtype = "ホスト"; }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
$menu_str
</tr>
</table>
</td>
</tr>
<tr>
<td class=data colspan=$colspan>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%">\u$jtype エスカレーション ツリー:</td>
<td class=$form_class>$name
<input type=hidden name=name value="$name">
<input type=hidden name=name value="$type">
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub escalation_tree(@) {
    my $ranks     = $_[1];
    my $templates = $_[2];
    my $obj_view  = $_[3];
    my %ranks     = %{$ranks};
    my %templates = %{$templates};
    my $detail    = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class valign=top width="25%">エスカレーション詳細:</td>
<td class=$form_class width="5%">&nbsp;</td>
<td class=$form_class>
<ol>);
    foreach my $rank ( sort { $a <=> $b } keys %ranks ) {
	$detail .= "\n<li>$templates{$ranks{$rank}}{'name'}\n<ul>";
	if ( $templates{ $ranks{$rank} }{'service_description'} ) {
	    unless ( $obj_view eq 'service_detail'
		|| $obj_view eq 'service_names' )
	    {
		$detail .= "\n<li>service_description: $templates{$ranks{$rank}}{'service_description'}</li>";
	    }
	}
	if ( $templates{ $ranks{$rank} }{'notification_interval'} ) {
	    my $val = $templates{ $ranks{$rank} }{'notification_interval'};
	    $val =~ s/-zero-/0/g;
	    $detail .= "\n<li>notification_interval: $val</li>";
	}
	if ( $templates{ $ranks{$rank} }{'first_notification'} ) {
	    my $val = $templates{ $ranks{$rank} }{'first_notification'};
	    $val =~ s/-zero-/0/g;
	    $detail .= "\n<li>first_notification: $val</li>";
	}
	if ( $templates{ $ranks{$rank} }{'last_notification'} ) {
	    my $val = $templates{ $ranks{$rank} }{'last_notification'};
	    $val =~ s/-zero-/0/g;
	    $detail .= "\n<li>last_notification: $val</li>";
	}
	if ( $templates{ $ranks{$rank} }{'contactgroups'} ) {
	    $detail .= "\n<li>contactgroups: $templates{$ranks{$rank}}{'contactgroups'}</li>";
	}
	$detail .= "</ul></li>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</ol>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub show_list(@) {
    my $ranks     = $_[1];
    my $templates = $_[2];
    my $obj_view  = $_[3];
    my %ranks     = %{$ranks};
    my %templates = %{$templates};
    my $detail    = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class valign=top width="25%">Escalation detail:
</td>
<td class=$form_class>
<ol>);
    foreach my $rank ( sort { $a <=> $b } keys %ranks ) {
	$detail .= "\n<li>$templates{$ranks{$rank}}{'name'}\n<ul>";
	if ( $templates{ $ranks{$rank} }{'service_description'} ) {
	    unless ( $obj_view eq 'service_detail' ) {
		$detail .= "\n<li>service_description: $templates{$ranks{$rank}}{'service_description'}</li>";
	    }
	}
	if ( $templates{ $ranks{$rank} }{'notification_interval'} ) {
	    $detail .= "\n<li>notification_interval: $templates{$ranks{$rank}}{'notification_interval'}</li>";
	}
	if ( $templates{ $ranks{$rank} }{'first_notification'} ) {
	    $detail .= "\n<li>first_notification: $templates{$ranks{$rank}}{'first_notification'}</li>";
	}
	if ( $templates{ $ranks{$rank} }{'last_notification'} ) {
	    my $val = $templates{ $ranks{$rank} }{'last_notification'};
	    $val =~ s/-zero-/0/g;
	    $detail .= "\n<li>last_notification: $val</li>";
	}
	if ( $templates{ $ranks{$rank} }{'contactgroups'} ) {
	    $detail .= "\n<li>contactgroups: $templates{$ranks{$rank}}{'contactgroups'}</li>";
	}
	$detail .= "</ul></li>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</ol>
</td>
</tr>);
    return $detail;
}

sub service_instances(@) {
    my %instances = %{ $_[1] };
    my $doc       = $_[2];
    my $tab       = $_[3];
    my $tabindex  = $tab ? "tabindex=\"$tab\"" : '';
    my $detail    = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td>
<table width="100%" cellspacing=0 align=left border=0>
<tr>
<td class=wizard_title colspan=4 valign=top colspan=3>複数インスタンス（オプション設定）</td>
</tr>
<tr>
<td class=wizard_body colspan=6>
<table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
<tr>
<td>
$doc
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=top_border width="100%" colspan=5>
<table width="100%" cellpadding=0 cellspacing=0 border=0>
<tr>
<td width="20%">インスタンスの添字&nbsp;</td>
<td width="10%"><input type=text size=20 name=inst value="" $tabindex></td>
<td width="45%">&nbsp;&nbsp; or　数字の範囲:&nbsp;&nbsp;<input type=text size=4 name=range_from value="" $tabindex>&nbsp;&nbsp;&ndash;&nbsp;&nbsp;<input type=text size=4 name=range_to value="" $tabindex></td>
<td>&nbsp;</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=top_border colspan=7 valign=top colspan=4>
<input class=submitbutton type=submit name=add_instance value="インスタンスの追加" $tabindex>
</td>
</tr>);
    if (%instances) {
	my @alph_sorted   = ();
	my @num_sorted    = ();
	my %instance_sort = ();
	foreach my $instance ( keys %instances ) {
	    my $inst = $instance;
	    $inst =~ s/^_//;
	    $inst .= rand();
	    if ( $inst =~ /^\d+/ ) {
		push @num_sorted, $inst;
	    }
	    else {
		push @alph_sorted, $inst;
	    }
	    $instance_sort{$inst} = $instances{$instance};
	    $instance_sort{$inst}{'name'} = $instance;
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<script language=JavaScript>
function doCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'rem_inst')
           elements[i].checked = true;
    }
  }
}
function doUnCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'rem_inst')
           elements[i].checked = false;
    }
  }
}
</script>
<tr>
<td class=top_border valign=top width="3%">&nbsp;</td>
<td class=top_border align=left valign=top width="20%"><b>インスタンスの添字</b></td>
<td class=top_border valign=top width="13%" colspan=2><b>ステータス</b></td>
<td class=top_border align=left valign=top width="50%"><b>引数</b></td>
</tr>);
	my $row = 1;

	foreach my $instance ( sort { $a <=> $b } @num_sorted ) {
	    my $class = undef;
	    if ( $row == 1 ) {
		$class = 'row_lt';
		$row   = 2;
	    }
	    elsif ( $row == 2 ) {
		$class = 'row_dk';
		$row   = 1;
	    }
	    my $checked = undef;
	    if ( $instance_sort{$instance}{'status'} ) { $checked = 'checked' }
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" valign=top width="3%">
<input type=checkbox name=rem_inst value=$instance_sort{$instance}{'id'} $tabindex>
</td>
<td class="$class" align=left valign=top width="20%">
<input type=text name=instance_$instance_sort{$instance}{'id'} value="$instance_sort{$instance}{'name'}" $tabindex>
</td>
<td class="$class" valign=top width="3%">
<input type=checkbox name=status_$instance_sort{$instance}{'id'} $checked value="$instance_sort{$instance}{'name'}" $checked $tabindex>
</td>
<td class="$class" align=left valign=top width="10%">Active</td>
<td class="$class" align=left valign=top width="64%">
<input type=text size=70 name=args_$instance_sort{$instance}{'id'} value="$instance_sort{$instance}{'args'}" $tabindex>
</td>
</tr>);
	}
	foreach my $instance ( sort { lc($a) cmp lc($b) } @alph_sorted ) {
	    my $class = undef;
	    if ( $row == 1 ) {
		$class = 'row_lt';
		$row   = 2;
	    }
	    elsif ( $row == 2 ) {
		$class = 'row_dk';
		$row   = 1;
	    }
	    my $checked = undef;
	    if ( $instance_sort{$instance}{'status'} ) { $checked = 'checked' }
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" valign=top width="3%">
<input type=checkbox name=rem_inst value=$instance_sort{$instance}{'id'} $tabindex>
</td>
<td class="$class" align=left valign=top width="20%">
<input type=text name=instance_$instance_sort{$instance}{'id'} value="$instance_sort{$instance}{'name'}" $tabindex>
</td>
<td class="$class" valign=top width="3%">
<input type=checkbox name=status_$instance_sort{$instance}{'id'} $checked value="$instance_sort{$instance}{'name'}" $checked $tabindex>
</td>
<td class="$class" align=left valign=top width="10%">Active</td>
<td class="$class" align=left valign=top width="64%">
<input type=text size=70 name=args_$instance_sort{$instance}{'id'} value="$instance_sort{$instance}{'args'}" $tabindex>
</td>
</tr>);
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=top_border colspan=5>
<input class=submitbutton type=submit name=remove_instance value="インスタンス削除" $tabindex>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェック" onclick=doCheckAll() $tabindex>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェックを外す" onclick=doUnCheckAll() $tabindex>
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>);

    return $detail;
}

sub dependency_list(@) {
    my $name         = $_[1];
    my $obj          = $_[2];
    my $service_id   = $_[3];
    my $session_id   = $_[4];
    my $dependencies = $_[5];
    my %dependencies = %{$dependencies};
    my $view         = 'manage_host';
    if ( $obj eq 'services' ) { $view = 'service' }
    my $now    = time;
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data2>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=row2 width="20%" align=left>依存関係
</td>
<td class=row2 width="40%" align=left>マスターサービスホスト
</td>
<td class=row2 width="40%" align=left>&nbsp;
</td>
</tr>);
    my $body = undef;
    $name =~ s/ /+/g;

    foreach my $dep ( sort { $a <=> $b } keys %dependencies ) {
	$body .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=row_lt align=left>$dependencies{$dep}[0]
</td>
<td class=row_lt align=left>$dependencies{$dep}[1]
</td>
<td class=row_lt align=center>
<a class=orange href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&top_menu=$obj&nocache=$now&view=$view&obj=$obj&obj_view=service_dependencies&name=$name&service_id=$service_id&dependency_id=$dep&remove_dependency=1 tabindex=-1>サービス依存関係割り当てを削除</a>
</td>
</tr>);
    }
    if ( !$body ) {
	$body .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=row_lt align=left colspan=3>定義された依存関係がありません
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
$body
</table>
</td>
</tr>);
    return $detail;
}

sub dependency_add(@) {
    my $dep_template  = $_[1];
    my $dep_templates = $_[2];
    my $hosts         = $_[3];
    my $docs          = $_[4];
    my $tab           = $_[5];
    my $tabindex      = $tab ? "tabindex=\"$tab\"" : '';
    my @dep_templates = @{$dep_templates};
    my @hosts         = @{$hosts};
    my %docs          = %{$docs};
    my $detail        = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%" align=left valign=top>依存関係:
</td>
<td class=$form_class width="3%" valign=top align=center><a class=orange href="#doc" title="$docs{'dependency'}">&nbsp;?&nbsp;</a>
<td class=$form_class align=left valign=top>
<select name=dep_template onChange="submit()" $tabindex>);

    if ( !$dep_templates[0] ) {
	$detail .= "\n<option value=''>-- 追加依存関係テンプレートなし --</option>";
    }

    $detail .= "\n<option selected value=''></option>";
    foreach my $item (@$dep_templates) {
	if ( $item eq $dep_template ) {
	    $detail .= "\n<option selected value=\"$item\">$item</option>";
	}
	else {
	    $detail .= "\n<option value=\"$item\">$item</option>";
	}
    }
    my $size = ( scalar @hosts ) + 1;
    $size = 20 if $size > 20;
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>&nbsp;&nbsp;
</td>
</tr>
<tr>
<td class=$form_class width="10%" align=left valign=top>マスターサービスホスト:
</td>
<td class=$form_class width="3%" valign=top align=center><a class=orange href="#doc" title="$docs{'master_host'}">&nbsp;?&nbsp;</a>
<td class=$form_class valign=top align=left>
<select name=depend_on_host size=$size $tabindex>);
    if ( !$hosts[0] ) {
	$detail .= "\n<option value=''>-- 追加依存ホストなし --</option>";
    }
    $detail .= "\n<option selected value=''></option>";
    foreach my $item (@hosts) {
	$detail .= "\n<option value=\"$item\">$item</option>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>&nbsp;&nbsp;
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub display_template(@) {
    my $template = $_[1];
    my $plist    = $_[2];
    my %template = %{$template};
    my @props    = split( /,/, $plist );
    my $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class valign=top width="25%">Detail:</td>
<td class=$form_class width="5%">&nbsp;</td>
<td class=$form_class align=left>
<table width="100%" cellpadding=2 cellspacing=0 border=0>);
    foreach my $p (@props) {
	if ( $p eq 'name' ) { next }
	$template{$p} =~ s/-zero-/0/g;
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="50%">$p</td>
<td class=$form_class align=left>$template{$p}
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub form_files(@) {
    my $upload_dir = $_[1];
    my $files      = $_[2];
    my $tab        = $_[3];
    my $tabindex   = $tab ? "tabindex=\"$tab\"" : '';
    my @files      = @{$files};
    my $detail     = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<script language=JavaScript>
function doCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'file')
           elements[i].checked = true;
    }
  }
}
function doUnCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'file')
           elements[i].checked = false;
    }
  }
}
</script>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    unless ( $files[0] ) {
	$detail .= "There are no eligible files in $upload_dir.";
    }
    else {
	foreach my $file ( sort @files ) {
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="10%" align=right><input type=checkbox name=file value="$file" $tabindex></td>
<td class=$form_class>$file</td>
</tr>);
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=top_border colspan=2>
<input class=submitbutton type=button value="すべてチェック" onclick=doCheckAll() $tabindex>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェックを外す" onclick=doUnCheckAll() $tabindex>
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>);

    return $detail;
}

sub form_groups(@) {
    my $groups   = $_[1];
    my $tab      = $_[2];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my %groups   = %{$groups};
    my $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<script language=JavaScript>
function doCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'group')
           elements[i].checked = true;
    }
  }
}
function doUnCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'group')
           elements[i].checked = false;
    }
  }
}
</script>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    unless ( scalar keys %groups ) {
	$detail .= "&nbsp;グループ定義がありません";
    }
    else {
	foreach my $group ( sort keys %groups ) {
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="10%" align=right><input type=checkbox name=group value="$group" $tabindex></td>
<td class=$form_class width="1%">$group</td>
<td class=$form_class width="1%">&nbsp;&nbsp;</td>
<td class=$form_class>$groups{$group}</td>
</tr>);
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=top_border colspan=4>
<input class=submitbutton type=button value="すべてチェック" onclick=doCheckAll() $tabindex>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェックを外す" onclick=doUnCheckAll() $tabindex>
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>);

    return $detail;
}

sub service_group(@) {
    my $session_id         = $_[1];
    my $view               = $_[2];
    my $name               = $_[3];
    my $host_services      = $_[4];
    my $host               = $_[5];
    my $host_nonmembers    = $_[6];
    my $hosts              = $_[7];
    my $service            = $_[8];
    my $service_nonmembers = $_[9];
    my $services           = $_[10];
    my $tab                = $_[11];
    my $tabindex           = $tab ? "tabindex=\"$tab\"" : '';

    my %host_services      = %{$host_services};
    my @hosts              = @{$hosts};
    my @host_nonmembers    = @{$host_nonmembers};
    my @services           = @{$services};
    my @service_nonmembers = @{$service_nonmembers};
    my $now                = time;
    $name =~ s/\s/+/g;
    my $hostn = $host;
    $hostn =~ s/\s/+/g;
    my $servicen = $service;
    $servicen =~ s/\s/+/g;
    my $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="40%" colspan=2 align=left>
<table class=form cellspacing=1 cellpadding=3 width="100%" align=left border=0>
<tr>
<td class=row2>ホスト</td>
<td class=row2>サービス</td>
<td class=row2 colspan=2>&nbsp;</td>
</tr>);

    unless (%host_services) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=row_lt valign=top>
&nbsp;
</td>
<td class=row_lt valign=top>
&nbsp;
</td>
<td class=row_lt align=center valign=top>
&nbsp;
</td>
</tr>);
    }
    foreach my $host ( sort keys %host_services ) {
	my $hname = $host;
	$hname =~ s/\s/+/g;
	foreach my $service ( @{ $host_services{$host} } ) {
	    my $sname = $service;
	    $sname =~ s/\s/+/g;
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=row_lt valign=top>
$host
</td>
<td class=row_lt valign=top>
$service
</td>
<td class=row_lt align=center valign=top>
<a class=orange href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&top_menu=services&nocache=$now&view=$view&obj=servicegroups&name=$name&host=$hostn&service=$servicen&del_host=$hname&del_service=$sname&remove_service=1 tabindex=-1>サービス割り当ての削除</a>
</td>
</tr>);
	}
    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class colspan=5>
<table width="100%" cellpadding=3 cellspacing=0 border=0>
<tr>
<td class=$form_class align=left width="10%" valign=top>ホスト:
<td class=$form_class align=left width="45%" valign=top>
<select name=host onChange="submit()" $tabindex>);
    unless (@hosts) {
	$detail .= "\n<option selected value=''></option>";
	$detail .= "\n<option value=''>-- ホストなし --</option>";
    }
    else {
	if ($host) {
	    $detail .= "\n<option value=''></option>";
	}
	else {
	    $detail .= "\n<option selected value=''></option>";
	}
	foreach my $h (@hosts) {
	    if ( $host eq $h ) {
		$detail .= "\n<option selected value=\"$host\">$host</option>";
	    }
	    else {
		$detail .= "\n<option value=\"$h\">$h</option>";
	    }
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>
</td>
<td class=$form_class rowspan=3 width="45%" valign=top align=left>
<select name=services size=10 multiple $tabindex>);
    my $options = undef;
    $detail .= "\n<option selected value=''></option>";
    foreach my $nmem (@host_nonmembers) {
	my $got_service = 0;
	foreach ( @{ $host_services{$host} } ) {
	    if ( $_ eq $nmem ) { $got_service = 1 }
	}
	unless ($got_service) {
	    $options .= "\n<option value=\"$nmem\">$nmem</option>";
	}
    }
    unless ($options) { $options = "\n<option value=''>-- サービスなし --</option>" }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
$options
</select>
</td>
</tr>
<tr>
<td class=$form_class align=left width="10%" valign=top>&nbsp;
<td class=$form_class align=left width="45%" valign=top><input class=submitbutton type=submit name=add_services value="サービス追加" $tabindex>
</td>
</tr>
<tr>
<td class=$form_class align=left width="10%" valign=top>&nbsp;
<td class=$form_class align=left width="45%" valign=top>&nbsp;
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<tr>
<td class=$form_class colspan=5>
<table width="100%" cellpadding=3 cellspacing=0 border=0>
<tr>
<td class=$form_class align=left width="10%" valign=top>サービス:
<td class=$form_class align=left width="45%" valign=top>
<select name=service onChange="submit()" $tabindex>);
    unless (@services) {
	$detail .= "\n<option selected value=''></option>";
	$detail .= "\n<option value=''>-- ホストなし --</option>";
    }
    else {
	if ($host) {
	    $detail .= "\n<option value=''></option>";
	}
	else {
	    $detail .= "\n<option selected value=''></option>";
	}
	foreach my $s (@services) {
	    if ( $service eq $s ) {
		$detail .= "\n<option selected value=\"$service\">$service</option>";
	    }
	    else {
		$detail .= "\n<option value=\"$s\">$s</option>";
	    }
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>
</td>
<td class=$form_class rowspan=3 valign=top width="45%">
<select name=hosts size=10 multiple $tabindex>);
    $options = undef;
    $detail .= "\n<option selected value=''></option>";
    foreach my $nmem (@service_nonmembers) {
	my $got_host = 0;
	foreach my $host ( keys %host_services ) {
	    if ( $host_services{$host} eq $service ) { $got_host = 1 }
	}
	unless ($got_host) {
	    $options .= "\n<option value=\"$nmem\">$nmem</option>";
	}
    }
    if ( !$options ) { $options = "\n<option value=''>-- ホストなし --</option>" }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
$options
</select>
</td>
</tr>
<tr>
<td class=$form_class align=left width="10%" valign=top>&nbsp;
<td class=$form_class align=left width="45%" valign=top><input class=submitbutton type=submit name=add_hosts value="ホスト追加" $tabindex>
</td>
</tr>
<tr>
<td class=$form_class align=left width="10%" valign=top>&nbsp;
<td class=$form_class align=left width="45%" valign=top>&nbsp;
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub resource_select() {
    my $res       = $_[1];
    my $selected  = $_[2];
    my $view      = $_[3];
    my %resources = %{$res};
    my %selected  = %{$selected};
    my $user      = $selected{'name'};
    $user =~ s/user//;
    my $comment = $resources{"resource_label$user"};
    my $detail  = undef;

    if ( $selected{'name'} ) {
        $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width=100% cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class align=left colspan=2 width=13%><input type=hidden name=resource value="$selected{'name'}">$selected{'name'}</td>
<td class=$form_class align=left width=70%><input type=text size=70 name=resource_value value="$selected{'value'}"></td>
<td class=$form_class align=left width=17%><input class=submitbutton type=submit name=update_resource value="更新"></td>
</tr>
<tr>
<td class=$form_class align=left colspan=2 width=13%>コメント:</td>
<td class=$form_class align=left width=70%><input type=text size=80 name=comment value="$comment"></td>
</tr>
</table>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width=100% cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class align=left width=17%></td>
</tr>
<tr>
<td class=top_menu_selected_bar align=left colspan=5>リソースマクロ選択:</td>
</tr>);
    for ( my $i = 1 ; $i < 33 ; $i++ ) {
        my $password = 0;
        if (   $view eq 'commands'
            && $resources{"resource_label$i"} =~ /password/i )
        {
            $password = 1;
        }
        unless ( $selected{'name'} eq "user$i" || $password ) {
            $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class align=left width=3% valign=top>
<input class=$form_class type=checkbox name=resource_user$i onClick="submit()"></td>
<td class=$form_class align=left width=10% valign=top>user$i
<td class=$form_class align=left width=70% valign=top>$resources{"user$i"});
            if ( $resources{"resource_label$i"} ) {
                my $doc = $resources{"resource_label$i"};
                $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<a class=orange href=#doc title="$doc" tabindex=-1>&nbsp;?&nbsp;</a>);
            }
            $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class=$form_class width=17% align=center>&nbsp;
</td>
</tr>);
        }
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</tr>
</table>
</td>
</td>);
    return $detail;
}

sub table_script_links(@) {
    my $session_id = $_[1];
    my $type       = $_[2];
    my $script     = $_[3];
    my %script     = %{$script};
    my $now        = time;
    my $detail     = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td valign=top>
<table width="75%" cellpadding=3 cellspacing=0 border=0>
<tr>
<td>\u$type Scripts</td>
</tr>);
    foreach my $name ( sort keys %script ) {

	unless ( $name =~ /HASH/ ) {
	    my $url = undef;
	    if ( $script{$name} =~ /Error/ ) {
		$url = qq(@{[&$Instrument::show_trace_as_html_comment()]}<h2>$name - $script{$name}</h2>);
	    }
	    else {
		$url =
qq(@{[&$Instrument::show_trace_as_html_comment()]}<a class=left href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&top_menu=control&nocache=$now&view=control&obj=run_external_scripts&ext_info=$name&type=$type>$name $script{$name}&nbsp;<img src=$doc_root_monarch/images/arrow.gif border=0></a>);
	    }
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}\n<tr>\n<td>$url\n</td>\n</tr>);
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>);
    return $detail;
}

sub radio_options(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $value    = $_[3];
    my $doc      = $_[4];
    my $tab      = $_[5];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my $other    = 'インターリーブファクターとして使用:';
    my %selected = ();
    my $text_val = undef;
    if ( $value eq 's' ) {
	$selected{'s'} = 'checked';
    }
    elsif ( $value eq 'd' ) {
	$selected{'d'} = 'checked';
    }
    elsif ( $value eq 'n' ) {
	$selected{'n'} = 'checked';
    }
    else {
	$selected{'other'} = 'checked';
	$text_val = $value;
    }
    $title =~ s/_/ /g;
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%" valign=top>\u$title</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class>
<table width="100%" cellpadding=3 cellspacing=0 border=0>);
    if ( $name =~ /inter_check_delay_method|service_inter_check_delay_method|host_inter_check_delay_method/ ) {
	$other = 'チェック間の遅延として使用:';
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=radio_option_$name value=n $selected{'n'} $tabindex>
</td>
<td class=$form_class>
なし
</td>
<td class=$form_class>
&nbsp;
</td>
</tr>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=radio_option_$name value=d $selected{'d'} $tabindex>
</td>
<td class=$form_class>
単純
</td>
<td class=$form_class>
&nbsp;
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=radio_option_$name value=s $selected{'s'} $tabindex>
</td>
<td class=$form_class>
高度
</td>
<td class=$form_class>
&nbsp;
</td>
</tr>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=radio_option_$name value=other $selected{'other'} $tabindex>
</td>
<td class=$form_class align=center width="35%">
$other
</td>
<td class=$form_class>
<input type=text size=5 name=other_$name value="$text_val" $tabindex>
</td>
</tr>
</table>);
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub log_rotation(@) {
    my $title    = $_[1];
    my $name     = $_[2];
    my $value    = $_[3];
    my $doc      = $_[4];
    my %selected = ();
    if ( $value eq 'n' ) {
	$selected{'n'} = 'checked';
    }
    elsif ( $value eq 'h' ) {
	$selected{'h'} = 'checked';
    }
    elsif ( $value eq 'd' ) {
	$selected{'d'} = 'checked';
    }
    elsif ( $value eq 'w' ) {
	$selected{'w'} = 'checked';
    }
    elsif ( $value eq 'm' ) {
	$selected{'m'} = 'checked';
    }
    $title =~ s/_/ /g;
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%" valign=top>\u$title</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class>
<table width="100%" cellpadding=3 cellspacing=0 border=0>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=log_rotation_method value=n $selected{'n'}>
</td>
<td class=$form_class>
なし
</td>
</tr>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=log_rotation_method value=h $selected{'h'}>
</td>
<td class=$form_class>
毎時
</td>
</tr>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=log_rotation_method value=d $selected{'d'}>
</td>
<td class=$form_class>
毎日
</td>
</tr>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=log_rotation_method value=w $selected{'w'}>
</td>
<td class=$form_class>
毎週
</td>
</tr>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=log_rotation_method value=m $selected{'m'}>
</td>
<td class=$form_class>
毎月
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub date_format(@) {
    my $value    = $_[1];
    my $doc      = $_[2];
    my $tab      = $_[3];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my %selected = ();
    if ( $value eq 'us' ) {
	$selected{'us'} = 'checked';
    }
    elsif ( $value eq 'euro' ) {
	$selected{'euro'} = 'checked';
    }
    elsif ( $value eq 'iso8601' ) {
	$selected{'iso8601'} = 'checked';
    }
    elsif ( $value eq 'strict-iso8601' ) {
	$selected{'strict-iso8601'} = 'checked';
    }

    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%" valign=top>日付フォーマット:</td>);
    if ($doc) {
	$detail .=
	  "\n<td class=$form_class width='3%' valign=top align=center>\n<a class=orange href='#doc' title=\"$doc\" tabindex=-1>&nbsp;?&nbsp;</a>";
    }
    else {
	$detail .= "\n<td class=$form_class width='3%' align=center>\n&nbsp;";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<td class=$form_class>
<table width="100%" cellpadding=3 cellspacing=0 border=0>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=date_format value=us $selected{'us'} $tabindex>
</td>
<td class=$form_class>
USA
</td>
<td class=$form_class>
(MM-DD-YYYY HH:MM:SS)
</td>
</tr>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=date_format value=euro $selected{'euro'} $tabindex>
</td>
<td class=$form_class>
International
</td>
<td class=$form_class>
(DD-MM-YYYY HH:MM:SS)
</td>
</tr>
<tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=date_format value=iso8601 $selected{'iso8601'} $tabindex>
</td>
<td class=$form_class>
ISO-8601
</td>
<td class=$form_class>
(YYYY-MM-DD HH:MM:SS)
</td>
</tr><tr>
<td class=$form_class width="5%">
<input type=radio class=radio name=date_format value=strict-iso8601 $selected{'strict-iso8601'} $tabindex>
</td>
<td class=$form_class>
strict-ISO-8601
</td>
<td class=$form_class>
(YYYY-MM-DDTHH:MM:SS)
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub mas_delete(@) {
    my %hosts  = %{ $_[1] };
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<script language=JavaScript>
function doCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'delete_host')
           elements[i].checked = true;
    }
  }
}
function doUnCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'delete_host')
           elements[i].checked = false;
    }
  }
}
</script>
<tr>
<td width="100%" align=center>
<div class="scroll" style="height: 400px;">
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    my $row      = 1;
    my $sort_num = $hosts{'sort_num'};
    delete $hosts{'sort_num'};
    foreach my $host ( sort keys %hosts ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}
	my $name = uri_escape($host);
	if ($sort_num) {
	    $name = uri_escape( $hosts{$host} );
	}
	else {
	    $hosts{$host} = '&nbsp;';
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class">
<input type=checkbox name=delete_host value=$name>&nbsp;
<img src=$doc_root_monarch/images/server.gif border=0>&nbsp;$host</a>
</td>
<td class="$class">
$hosts{$host} &nbsp;
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</div>
</td>
</tr>);
    return $detail;
}

sub search_results(@) {
    my $objects    = $_[1];
    my $session_id = $_[2];
    my $type       = $_[3];
    my $num_more   = $_[4];
    use URI::Escape;
    my $now     = time;
    my %objects = %{$objects};
    my $detail  = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
);

    if (%objects) {
	my @objects = ();
	if ( $objects{'sort_num'} ) {
	    delete $objects{'sort_num'};
	    @objects = sort { $objects{$a} cmp $objects{$b} } keys %objects;
	}
	else {
	    # We use uc, not lc, here to match MySQL collation vs. punctuation.
	    @objects = sort { uc($a) cmp uc($b) } keys %objects;
	}
	my $row = 1;
	foreach my $object (@objects) {
	    my $class = undef;
	    if ( $row == 1 ) {
		$class = 'row_lt';
		$row   = 2;
	    }
	    elsif ( $row == 2 ) {
		$class = 'row_dk';
		$row   = 1;
	    }
	    my $name = $object;
	    $name =~ s/\s/+/g;
	    $name = uri_escape($name);

	    if ( $type eq 'service' ) {
		$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class">
<a class=left href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&nocache=$now&top_menu=services&view=service&obj=services&obj_view=service_detail&name=$name title="$object">
<img src=$doc_root_monarch/images/service-blue.gif border=0>&nbsp;$objects{$object}</a>
</td>
</tr>);
	    }
	    elsif ( $type eq 'host_external' ) {
		$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class">
<a class=left href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&nocache=$now&top_menu=hosts&view=host_externals&obj=host_externals&task=modify&name=$name title="$object">
<img src=$doc_root_monarch/images/template.gif border=0>&nbsp;$objects{$object}</a>
</td>
</tr>);
	    }
	    elsif ( $type eq 'service_external' ) {
		$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class">
<a class=left href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&nocache=$now&top_menu=services&view=service_externals&obj=service_externals&task=modify&name=$name title="$object">
<img src=$doc_root_monarch/images/template.gif border=0>&nbsp;$objects{$object}</a>
</td>
</tr>);
	    }
	    elsif ( $type eq 'ez' ) {
		$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class">
<a class=left href=$cgi_dir/monarch_ez.cgi?update_main=1&CGISESSID=$session_id&nocache=$now&top_menu=hosts&view=hosts&obj=hosts&name=$name title="$object">
<img src=$doc_root_monarch/images/server.gif border=0>&nbsp;$objects{$object}</a>
</td>
</tr>);
	    }
	    elsif ( $type eq 'delete_hosts' ) {
		$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class">
<input type=checkbox name=delete_host value=$name>&nbsp;
<img src=$doc_root_monarch/images/server.gif border=0>&nbsp;$objects{$object}</a>
</td>
</tr>);
	    }
	    else {
		my $ipaddr = '';
		if ($object ne $objects{$object}) {
		    $ipaddr = 
qq(&nbsp;<a class=left href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&nocache=$now&top_menu=hosts&view=manage_host&obj=hosts&name=$name title="$object">$objects{$object}</a>);
		}
		$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class">
<a class=left href=$cgi_dir/$cgi_exe?update_main=1&CGISESSID=$session_id&nocache=$now&top_menu=hosts&view=manage_host&obj=hosts&name=$name title="$object">
<img src=$doc_root_monarch/images/server.gif border=0>&nbsp;$object</a>
</td>
<td class="$class">$ipaddr</td>
<td class="$class" width="80%"></td>
</tr>);
	    }
	}
    }
    else {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=row_lt>
&nbsp;Nothing found
</td>
</tr>);
    }
    if ( $num_more > 0 ) {
	$detail .= "\n<tr><td class=row2 colspan='3'>($num_more more)</td></tr>";
    }
    $detail .= "\n</table>";
    return $detail;
}

sub search(@) {
    my $session_id      = $_[1];
    my $type            = $_[2];
    my $value           = $_[3];
    my $search_function = '';
    my $caption         = "ホスト名かアドレスの一部を入力してください。:";
    if ( $type eq 'services' ) {
	$caption = "サービス名の一部分を入力してください。:";
    }
    elsif ( $type eq 'host_externals' ) {
	$caption = "Input any part of a host external name:";
    }
    elsif ( $type eq 'service_externals' ) {
	$caption = "Input any part of a service external name:";
    }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class>$caption</td>
<td class=$form_class>
<input type=hidden id=CGISESSID name=CGISESSID value=$session_id>);

    # We impose an imperceptible delay to cut down on excess queries.
    if ( $type eq 'services' ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<input type=hidden id=service name=service value=service>);
	$search_function = 'find_services';
    }
    elsif ( $type eq 'host_externals' ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<input type=hidden id=external name=external value=external>
<input type=hidden id=type name=type value=host>);
	$search_function = 'find_externals';
    }
    elsif ( $type eq 'service_externals' ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<input type=hidden id=external name=external value=external>
<input type=hidden id=type name=type value=service>);
	$search_function = 'find_externals';
    }
    elsif ( $type eq 'ez' ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<input type=hidden id=ez name=ez value=ez>);
	$search_function = 'find_ez_hosts';
    }
    else {
	$search_function = 'find_hosts';
    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<input type=text name=input id="val1" size=60 onkeyup="setTimeout ($search_function, 200);">
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=data>
<script language=JavaScript>
function SetInputFocus() {
    document.getElementById('val1').focus();
}
SafeAddOnload(SetInputFocus);

var UseEyeCandy = false;
var KillOldResults = false;
function erase_cover() {
    document.getElementById('grayarea').removeChild(document.getElementById('coverGlass'));
}
function show_cover() {
    if (document.getElementById('coverGlass')) return; 
    sheet = document.getElementById('grayarea').appendChild(document.createElement('div'));
    sheet.style.top = '-3000px';
    sheet.style.width  = document.getElementById('grayarea').offsetWidth  + 'px';
    sheet.style.height = document.getElementById('grayarea').offsetHeight + 'px';
    sheet.style.left   = document.getElementById('grayarea').offsetLeft   + 'px';
    sheet.style.top    = document.getElementById('grayarea').offsetTop    + 'px';
    sheet.id = 'coverGlass';
    sheet.onclick = function() { this.blur(); erase_cover(); return false; }
}
var LastRequestTime = new Date();
var LastDisplayTime = new Date();
var LastRequest = '';
var LastDisplay = '';
function show_results() {
    var arr = arguments[0].split('|');
    var response = arr[0];
    var request  = arr[1];
    // Do not display obsolete or redundant results.
    if (document.getElementById("val1").value == request) {
	if (UseEyeCandy) {
	    erase_cover();
	}
	document.getElementById('searchdiv').innerHTML = '検索結果:';
	var now = new Date();
	if (request != LastDisplay || (now.getTime() - LastDisplayTime.getTime()) > 2000) {
	    document.getElementById('resultdiv').innerHTML = response;
	    LastDisplayTime = now;
	    LastDisplay = request;
	}
    }
}
// Avoid pointless successive identical requests.
function find_objects(get_objects) {
    var request = document.getElementById("val1").value;
    var now = new Date();
    if (request != LastRequest || (now.getTime() - LastRequestTime.getTime()) > 3000) {
	LastRequestTime = now;
	LastRequest = request;
	document.getElementById('searchdiv').innerHTML = '<font color=#CC0000>検索中...</font>';
	if (UseEyeCandy) {
	    show_cover();
	} else if (KillOldResults) {
	    document.getElementById('resultdiv').innerHTML = '&nbsp;';
	    LastDisplay = '';
	}
	eval (get_objects);
    }
}
function find_services() {
    find_objects( "get_services( ['service','val1','CGISESSID'], [show_results] )" );
}
function find_externals() {
    find_objects( "get_externals( ['external','type','val1','CGISESSID'], [show_results] )" );
}
function find_ez_hosts() {
    find_objects( "get_ez( ['ez','val1','CGISESSID'], [show_results] )" );
}
function find_hosts() {
    find_objects( "get_hosts( ['val1','CGISESSID'], [show_results] )" );
}
function find_names() {
    $search_function();
}
</script>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=row2>
<div id="searchdiv">
結果が下記に表示されます。
</div>
</td>
</tr>
<tr>
<td class=$form_class id="grayarea" style="position: relative;">
<div id="resultdiv">
&nbsp;
</div>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub toggle_delete() {
    my $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td>
<table width="100%" cellpadding=0 cellspacing=0 align=left border=0>
<tr>
<td><input class=submitbutton type=submit name=remove_host value="削除">&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェック" onclick=doCheckAll()>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェックを外す" onclick=doUnCheckAll()>&nbsp;&nbsp;
<input type=submit class=submitbutton name=close value="閉じる">
</td>
</tr>
</form>
</table>
</td>
</tr>);
    return $detail;
}

sub wizard_doc(@) {
    my $title       = $_[1];
    my $body        = $_[2];
    my $emphasize   = $_[3];
    my $title_begin = '';
    my $title_end   = '';
    my $body_begin  = '';
    my $body_end    = '';
    if ($emphasize) {
	$title_begin = '<font color=#FF0000>';
	$title_end   = '</font>';
	$body_begin  = '<b><i>';
	$body_end    = '</i></b>';
    }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=wizard_title valign=top>$title_begin$title$title_end</td>
</tr>);

    if ( defined($body) ) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=wizard_body>
<table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
<tr>
<td class=wizard_body>$body_begin$body$body_end</td>
</tr>
</table>
</td>
</tr>);
    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>);

    return $detail;
}

sub process_load(@) {
    my $load_option    = $_[1];
    my $escalation     = $_[2];
    my $nagios_etc     = $_[3];
    my $abort          = $_[4];
    my $continue       = $_[5];
    my $precached_file = $_[6];
    my $now            = time;
    my $input_tags     = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<input type=hidden id="nocache" name=nocache value=$now>
<input type=hidden id="end" name=end value=end>
<input type=hidden id="process_load" name=process_load value=process_load>
<input type=hidden id="load_option" name=load_option value=$load_option>
<input type=hidden id="escalation" name=escalation value=$escalation>
<input type=hidden id="precached_file" name=precached_file value="$precached_file">
<input type=hidden id="nagios_etc" name=nagios_etc value=$nagios_etc>
<input type=hidden id="process_service_escalations" name=process_service_escalations value=process_service_escalations>
<input type=hidden id="process_host_escalations" name=process_host_escalations value=process_host_escalations>
<input type=hidden id="services" name=services value=services>
<input type=hidden id="hosts" name=hosts value=hosts>
<input type=hidden id="contacts" name=contacts value=contacts>
<input type=hidden id="timeperiods" name=timeperiods value=timeperiods>
<input type=hidden id="commands" name=commands value=commands>
<input type=hidden id="stage" name=stage value=stage>
<input type=hidden id="purge" name=purge value=purge>);
    my @steps = ('end');

    if ( $escalation || $load_option =~ /purge/ ) {
	push( @steps, ( 'process_service_escalations', 'process_host_escalations' ) );
    }
    push( @steps, ( 'services', 'hosts', 'contacts', 'timeperiods', 'commands', 'stage', 'purge' ) );
    my $i         = 0;
    my $array_str = undef;
    foreach my $step (@steps) {
	$array_str .= qq(steps[$i]="$step";);
	$i++;
    }
    my $javascript = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<SCRIPT language="JavaScript">
var got_error = false;
var steps= new Array($i)
$array_str
function check_status() {
	var step = steps.pop()
	if (step==undefined) {
		if (got_error) {
		    document.getElementById("status").innerHTML = "Finished with error(s); see below for detail.";
		    document.getElementById("status").style.color = "#CC0000";
		    document.getElementById("status").style.fontWeight = 'bold';
		}
		else {
		    document.getElementById("status").innerHTML = "Finished";
		}
		document.getElementById("continue_abort").value="$continue";
	}
	else {
		var str = '';
		if (step=='process_service_escalations') str = 'Processing service escalations ...';
		if (step=='process_host_escalations') str = 'Processing host escalations ...';
		if (step=='services') str = 'Processing services ...';
		if (step=='hosts') str = 'Processing hosts ...';
		if (step=='contacts') str = 'Processing contacts ...';
		if (step=='timeperiods') str = 'Processing timeperiods ...';
		if (step=='commands') str = 'Processing commands ...';
		if (step=='stage') str = 'Reading files ...';
		if (step=='purge') str = 'Preparing load ...';
		document.getElementById("continue_abort").value="$abort";
		document.getElementById("status").innerHTML = str;
		process_load( ['process_load',step,'nagios_etc','load_option','escalation','precached_file'], [report_status] )
	}
}

function report_status(id) {
	var args = arguments[0].split('|')
	var items = args.length
	for (i=0; i<items; i++) {
		var fields = args[i].split('~~')
		var tbody = document.getElementById("reportTable").getElementsByTagName("TBODY")[0];
		var row = document.createElement("TR")
		var td1 = document.createElement("TD")
		td1.appendChild(document.createTextNode(fields[0]))
		var td2 = document.createElement("TD")
		td2.appendChild (document.createTextNode(fields[1]))
		var td3 = document.createElement("TD")
		td3.appendChild (document.createTextNode(fields[2]))
		if (fields[1] == 'error') {
			got_error = true;
			td2.style.color = '#CC0000';
			td3.style.color = '#CC0000';
			td2.style.fontWeight = 'bold';
			td3.style.fontWeight = 'bold';
		}
		row.appendChild(td1);
		row.appendChild(td2);
		row.appendChild(td3);
		tbody.appendChild(row);
	}
	check_status()
}
</SCRIPT>
);

    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class valign=top width="25%">Status:</td>
<td class=$form_class><div id="status"></div>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
$javascript
$input_tags
<div class="scroll">
<table id="reportTable" width="100%" cellpadding=7 cellspacing=0 align=left border=0>
<tbody>
</tbody>
</table>
</div>
</td>
</tr>
<tr>
<td>
<table width="100%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td style=border:0 align=left>
<input class=submitbutton id="continue_abort" type=submit name=continue value=''>
</td>
</tr>
</form>
</table>
</td>
</tr>);

}

sub load_options(@) {
    my $load_option    = $_[1];
    my $precached_file = $_[2];
    my $tab            = $_[3];
    my $tabindex       = $tab ? "tabindex=\"$tab\"" : '';
    my %selected       = (
	'update'                  => '',
	'purge_all'               => '',
	'purge_all_and_import_3x' => '',
	'purge_nice'              => '',
    );
    if ( !$load_option ) {
	$load_option = 'update';
    }
    $selected{$load_option} = 'checked';
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=wizard_title valign=top>ロードオプション</td>
</tr>
<tr>
<td class=wizard_body>
<table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
<tr>
<td class=wizard_body width="3%" valign=top>
<input class=radio type=radio name=load_option value=update $selected{'update'} $tabindex></td>
</td>
<td class=wizard_body colspan="2"><i>更新</i> (デフォルト): ファイル定義からオブジェクトを追加、更新します。注意: 下記の"エスカレーションのロード"を選択しないかぎり、エスカレーションは除外されます。
</td>
</tr>
<tr>
<td class=wizard_body width="3%">&nbsp;</td>
<td class=wizard_body width="3%" valign=top>
<input class=checkbox type=checkbox name=purge_escalations $tabindex></td>
</td>
<td class=wizard_body><i>エスカレーションのロード</i>: ファイル定義からエスカレーションを置き換えます。エスカレーションを更新するオプションはありません。</td>
</tr>
<tr>
<td class=wizard_body width="3%" valign=top>
<input class=radio type=radio name=load_option value=purge_all $selected{'purge_all'} $tabindex></td>
</td>
<td class=wizard_body colspan="2"><i>すべてをパージ</i>: プロファイルおよびその関連付けを含め、すべての Nagiosレコードをデータベースから削除します。このオプションを使用すると、ファイル定義に基づいてデータベースに値が設定されます。</td>
</tr>
<tr>
<td class=wizard_body width="3%" valign=top>
<input class=radio type=radio name=load_option value=purge_all_and_import_3x $selected{'purge_all_and_import_3x'} $tabindex></td>
</td>
<td class=wizard_body colspan="2"><i>Nagios 3.x インポート</i>: <i>すべてをパージ</i> と同様に、データベースの 全 Nagios レコードをクリアし、Nagios 3.x のコンフィグレーションファイルからのデータで置き換えます。このオプションを使うには、コマンドラインから <b>nagios -vp /usr/local/aemonitor/nagios/etc/nagios.cfg</b> を実行することにより、<i>プリキャッシュされたオブジェクトファイル</i> を作っておく必要があります。インポートプロセスは、メインの nagios.cfg ファイルおよび、参照によってインクルードされたファイルをそれら内で見出されるテンプレートを引き出すために、読み込みます。テンプレートは Monarch 内に読み込まれますが、どのオブジェクトとも関係付けられません。あなたは、プロファイルにテンプレートを追加し、プロファイルをホストや他のオブジェクトに適用することで、それを後で行うことができます。</td>
</tr>
<tr>
<td class=wizard_body width="3%">&nbsp;</td>
<td class=wizard_body colspan="2"><i>プリキャッシュされたオブジェクトファイル</i>: <input type=text size=75 name=precached_file value="$precached_file" $tabindex></td>
</tr>
<tr>
<td class=wizard_body valign=top>
<input class=radio type=radio name=load_option value=purge_nice $selected{'purge_nice'} $tabindex></td>
</td>
<td class=wizard_body colspan="2"><i>高度なパージ</i>: Nagiosの、サービス、サービス依存関係、サービステンプレート、エスカレーションなどサービス関連のレコードは削除しますが、ホスト、コマンド、時間帯、連絡先、プロファイル（サービスプロファイルも含む）は残します。ホスト、コマンド、時間帯、連絡先はファイル定義に基づいて更新されます。サービスプロファイルは空のままです。
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);
}

sub form_process_hosts(@) {
    my $unsorted_hosts  = $_[1];
    my $host_data       = $_[2];
    my $delimiter       = $_[3];
    my $fields          = $_[4];
    my $exists          = $_[5];
    my $profiles        = $_[6];
    my $default_profile = $_[7];
    my $sort            = $_[8];
    my $ascdesc         = $_[9];
    my @unsorted_hosts  = @{$unsorted_hosts};
    my %host_data       = %{$host_data};
    my %fields          = %{$fields};
    my %exists          = %{$exists};
    my %profiles        = %{$profiles};
    my @hosts           = ();
    my %checked         = ();
    my %sorted          = ();
    my %sort_order      = (
	'exception' => 'asc',
	'exists'    => 'asc',
	'good'      => 'asc',
	'name'      => 'asc',
	'alias'     => 'asc',
	'address'   => 'asc',
	'os'        => 'asc',
	'profile'   => 'asc',
	'other'     => 'asc'
    );

    if ($sort) {
	@{ $sorted{'os'} }        = ();
	@{ $sorted{'address'} }   = ();
	@{ $sorted{'alias'} }     = ();
	@{ $sorted{'profile'} }   = ();
	@{ $sorted{'other'} }     = ();
	@{ $sorted{'exception'} } = ();
	@{ $sorted{'exists'} }    = ();
	@{ $sorted{'good'} }      = ();
	foreach my $host (@unsorted_hosts) {
	    my @values = split( /$delimiter/, $host_data{$host} );
	    if ( $delimiter eq 'tab' ) {
		@values = split( /\t/, $host_data{$host} );
	    }
	    if ( $sort eq 'os' ) {
		unless ( $values[ $fields{'os'} ] ) {
		    $values[ $fields{'os'} ] = "&nbsp;---&nbsp;";
		}
		push @{ $sorted{ $values[ $fields{'os'} ] } }, $values[ $fields{'name'} ];
	    }
	    elsif ( $sort eq 'address' ) {
		push @{ $sorted{ $values[ $fields{'address'} ] } }, $values[ $fields{'name'} ];
	    }
	    elsif ( $sort eq 'alias' ) {
		unless ( $values[ $fields{'alias'} ] ) {
		    $values[ $fields{'alias'} ] = $values[ $fields{'name'} ];
		}
		push @{ $sorted{ $values[ $fields{'alias'} ] } }, $values[ $fields{'name'} ];
	    }
	    elsif ( $sort eq 'profile' ) {
		my $profile = '&nbsp;---&nbsp;';
		if ( $profiles{ $values[ $fields{'profile'} ] } ) {
		    $profile = $values[ $fields{'profile'} ];
		}
		push @{ $sorted{$profile} }, $values[ $fields{'name'} ];
	    }
	    elsif ( $sort eq 'other' ) {
		push @{ $sorted{ $values[ $fields{'other'} ] } }, $values[ $fields{'name'} ];
	    }
	    elsif ($sort eq 'exception'
		|| $sort eq 'exists'
		|| $sort eq 'good' )
	    {
		unless ( $values[ $fields{'alias'} ] ) {
		    $values[ $fields{'alias'} ] = $values[ $fields{'name'} ];
		}
		if (   $values[ $fields{'name'} ]
		    && $values[ $fields{'address'} ] )
		{
		    if ( $exists{ $values[ $fields{'name'} ] } ) {
			push @{ $sorted{'exists'} }, $values[ $fields{'name'} ];
			if ( $sort eq 'exists' ) { $checked{$host} = 'checked' }
		    }
		    else {
			push @{ $sorted{'good'} }, $values[ $fields{'name'} ];
			if ( $sort eq 'good' ) { $checked{$host} = 'checked' }
		    }
		}
		else {
		    push @{ $sorted{'exception'} }, $values[ $fields{'name'} ];
		    if ( $sort eq 'exception' ) { $checked{$host} = 'checked' }
		}
	    }
	}
	if ( $sort eq 'exception' || $sort eq 'exists' || $sort eq 'good' ) {
	    my @order = ();
	    if ( $sort eq 'exception' ) {
		@order = ( 'exception', 'exists', 'good' );
	    }
	    elsif ( $sort eq 'exists' ) {
		@order = ( 'exists', 'good', 'exception' );
	    }
	    else {
		@order = ( 'good', 'exception', 'exists' );
	    }
	    foreach my $key (@order) {
		@{ $sorted{$key} } =
		  sort { lc($a) cmp lc($b) } @{ $sorted{$key} };
		push( @hosts, @{ $sorted{$key} } );
	    }
	    $sort_order{$sort} = 'asc';
	}
	else {
	    if ( $ascdesc eq 'asc' ) {
		foreach my $key ( sort { lc($a) cmp lc($b) } keys %sorted ) {
		    @{ $sorted{$key} } =
		      sort { lc($a) cmp lc($b) } @{ $sorted{$key} };
		    push( @hosts, @{ $sorted{$key} } );
		}
		$sort_order{$sort} = 'desc';
	    }
	    else {
		foreach my $key ( sort { lc($b) cmp lc($a) } keys %sorted ) {
		    @{ $sorted{$key} } =
		      sort { lc($a) cmp lc($b) } @{ $sorted{$key} };
		    push( @hosts, @{ $sorted{$key} } );
		}
		$sort_order{$sort} = 'asc';
	    }
	}
    }
    else {
	if ( $ascdesc eq 'asc' ) {
	    @hosts = sort { lc($a) cmp lc($b) } @unsorted_hosts;
	    $sort_order{'name'} = 'desc';
	}
	else {
	    @hosts = sort { lc($b) cmp lc($a) } @unsorted_hosts;
	    $sort_order{'name'} = 'asc';
	}
    }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<script language=JavaScript>
function doCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'host_checked')
           elements[i].checked = true;
    }
  }
}
function doUnCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'host_checked')
           elements[i].checked = false;
    }
  }
}
</script>

<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="15%">ソートキー:</td>
<td class=$form_class align=left width="1%">
<div style="width:8px; height:8px; border:1px solid #000099; background-color:#F3B50F;"></div>
</td>
<td class=$form_class align=left width="20%"><input class=row1button type=submit name=sort_exception_$sort_order{'exception'} value="&nbsp;Exception: Missing data, unable to import.&nbsp;&nbsp;">
</td>
<td class=$form_class align=left width="1%">
<div style="width:8px; height:8px; border:1px solid #000099; background-color:#8DD9E0;"></div>
</td>
<td class=$form_class align=left width="10%"><input class=row1button type=submit name=sort_exists_$sort_order{'exists'} value="&nbsp;Host exists.&nbsp;&nbsp;">
</td>
<td class=$form_class align=left width="1%">
<div style="width:8px; height:8px; border:1px solid #000099; background-color:#FFFFFF;"></div>
</td>
<td class=$form_class align=left width="10%"><input class=row1button type=submit name=sort_good_$sort_order{'good'} value="&nbsp;Good.">
</td>
<td class=$form_class align=left>&nbsp;
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class allign=left>ソートカラム:&nbsp;
<input class=row1button type=submit name=sort_name_$sort_order{'name'} value=Name>&nbsp;
<input class=row1button type=submit name=sort_alias_$sort_order{'alias'} value=Alias>&nbsp;
<input class=row1button type=submit name=sort_address_$sort_order{'address'} value=Address>&nbsp;
<input class=row1button type=submit name=sort_os_$sort_order{'os'} value=OS>&nbsp;
<input class=row1button type=submit name=sort_profile_$sort_order{'profile'} value=Profile>&nbsp;
<input class=row1button type=submit name=sort_other_$sort_order{'other'} value=Other>&nbsp;
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<div class="scroll" style="height: 250px;">
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    my $class = undef;
    foreach my $host (@hosts) {
	unless ($host) { next }
	my @values = split( /$delimiter/, $host_data{$host} );
	if ( $delimiter eq 'tab' ) {
	    @values = split( /\t/, $host_data{$host} );
	}
	unless ( $values[ $fields{'alias'} ] ) {
	    $values[ $fields{'alias'} ] = $values[ $fields{'name'} ];
	}
	if ( $values[ $fields{'name'} ] && $values[ $fields{'address'} ] ) {
	    $class = 'row_good';
	    if ( $exists{ $values[ $fields{'name'} ] } ) {
		$class = 'row_exists';
	    }
	}
	else {
	    $class = 'row_exception';
	}
	my $profile = '&nbsp;---&nbsp;';
	if ( $profiles{ $values[ $fields{'profile'} ] } ) {
	    $profile = $values[ $fields{'profile'} ];
	}
	$host                         =~ s/^\s+|\s+$//g;
	$values[ $fields{'alias'} ]   =~ s/^\s+|\s+$//g;
	$values[ $fields{'address'} ] =~ s/^\s+|\s+$//g;
	$values[ $fields{'os'} ]      =~ s/^\s+|\s+$//g;
	$values[ $fields{'other'} ]   =~ s/^\s+|\s+$//g;
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" width=15px>
<input type=checkbox name=host_checked value="$host" $checked{$host}>
</td>
<td class="$class" width=100px>$host
<input type=hidden name=host value="$host">
</td>
<td class="$class" width=200px>$values[$fields{'alias'}]
<input type=hidden name="alias_$host" value="$values[$fields{'alias'}]">
</td>
<td class="$class" width=110px>$values[$fields{'address'}]
<input type=hidden name="address_$host" value="$values[$fields{'address'}]">
</td>
<td class="$class" width=150px>$values[$fields{'os'}]</td>
<input type=hidden name="os_$host" value="$values[$fields{'os'}]">
<td class="$class" width=100px>$profile</td>
<input type=hidden name="profile_$host" value="$profile">
<td class="$class" width=100px>$values[$fields{'other'}]</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td>
<input class=submitbutton type=button value="すべてチェック" onclick=doCheckAll()>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェックを外す" onclick=doUnCheckAll()>
</td>
</tr>
</table>
</td>
</tr>);

    return $detail;
}

sub form_profiles(@) {
    my $default         = $_[1];
    my $selected        = $_[2];
    my $profiles        = $_[3];
    my $profiles_detail = $_[4];
    my $doc             = $_[5];
    my @profiles        = @{$profiles};
    my %profiles_detail = %{$profiles_detail};
    my %checked         = ();
    my $checked         = undef;
    unless ($selected) { $selected = $default }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td>
<div class="scroll" style="height: 150px;">
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=row2 colspan=3>ホストプロファイル:</td>
<td class=row2>ホストグループ:</td>
<td class=row2 colspan=2>サービスプロファイル:</td>
</tr>);
    my $row = 1;

    foreach my $profile (@profiles) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}
	$checked = undef;
	if ( $selected eq $profile ) { $checked = 'checked' }
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" width="3%" valign=top>
<input class=radio type=radio name=host_profile value="$profile" $checked tabindex=></td>
<td class="$class" valign=top>$profile</td>
<td class="$class" valign=top>$profiles_detail{$profile}{'description'}</td>
<td class="$class" valign=top>);
	if ( $profiles_detail{$profile}{'hostgroups'} ) {
	    foreach my $hg ( sort { $a <=> $b } @{ $profiles_detail{$profile}{'hostgroups'} } ) {
		$detail .= "$hg<br>\n";
	    }
	}
	else {
	    $detail .= "&nbsp;\n";
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class="$class" valign=top>);
	delete $profiles_detail{$profile}{'hostgroups'};
	delete $profiles_detail{$profile}{'description'};
	foreach my $sp ( sort keys %{ $profiles_detail{$profile} } ) {
	    $detail .= "$sp<br>\n";
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
<td class="$class" valign=top>);
	foreach my $sp ( sort keys %{ $profiles_detail{$profile} } ) {
	    $detail .= "$profiles_detail{$profile}{$sp}<br>\n";
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</div>);
    return $detail;
}

sub form_discover() {
    my $oct1 = $_[1];
    my $oct2 = $_[2];
    my $oct3 = $_[3];
    my $oct4 = $_[4];
    my $oct5 = $_[5];
    unless ($oct4) { $oct4 = '*' }
    return qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="25%">アドレス、範囲、またはサブネットを入力してください:</td>
<td class=$form_class>
<input type=text size=4 name=oct1 value=$oct1>&nbsp;.&nbsp;<input type=text size=4 name=oct2 value=$oct2>&nbsp;.&nbsp;<input type=text size=4 name=oct3 value=$oct3>&nbsp;.&nbsp;<input type=text size=4 name=oct4 value=$oct4>&nbsp;-&nbsp;<input type=text size=4 name=oct5 value=$oct5></td>
</tr>
</table>
</td>
</tr>);
}

sub get_file_url(@) {
    my $file = $_[1];
    my $line = $_[2];
    my $url  = '';

    # Security check.
    if (   $file =~ m@^/monarch/workspace/[a-z._]+$@
	|| $file =~ m@^/profiles/[^./][^/]*$@ )
    {
	$url = "$cgi_dir/monarch_file.cgi?file=$file";
	if ($line) {

	    # Position so the desired line is in the middle, not at the top.
	    $line -= 25;
	    $line = 1 if $line <= 0;
	    $url .= "#line$line";
	}
    }
    return $url;
}

sub filter_results(@) {
    my $results = $_[1];
    foreach (@$results) {
	my $file = '';
	my $line = 0;
	if (m@(/usr/local/aemonitor/core/monarch/workspace/[a-z_.]+).* [lL]ine (\d+)@) {
	    $file = $1;
	    $line = $2;
	}
	elsif (m@(/usr/local/aemonitor/core/monarch/workspace/[a-z_.]+)@) {
	    $file = $1;
	}
	if ($file) {
	    ( my $relative_file = $file ) =~ s@/usr/local/aemonitor/core@@;
	    my $url = get_file_url( '', $relative_file, $line );
	    s@$file@<a href="$url" target="_blank"><b><code>$file</code></b></a>@;
	}
    }
}

sub get_ajax_url() {
    my $nocache = time;
    return "$cgi_dir/monarch_ajax.cgi?nocache=$nocache";
}

sub get_scan_url() {
    my $nocache = time;
    return "$cgi_dir/monarch_scan.cgi?nocache=$nocache";
}

sub scan(@) {
    my $addresses    = $_[1];
    my $elements     = $_[2];
    my $file         = $_[3];
    my $monarch_home = $_[4];
    my @addresses    = @{$addresses};
    my $input_tags   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<input type=hidden id=file name=file value=$file>
<input type=hidden id=monarch_home name=file value=$monarch_home>);
    my $javascript = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<SCRIPT language="JavaScript">
var ips= new Array($elements));
    @addresses = reverse @addresses;
    my $i = 0;

    foreach my $ip (@addresses) {
	$javascript .= qq(
ips[$i]="$ip";);
	$input_tags .= qq(
<input type=hidden id="$ip" name=ip value=$ip>);
	$i++;
    }
    $javascript .= qq(
function scan_host() {
	var host = ips.pop()
	if (host==undefined) {
		document.getElementById("status").innerHTML = "Finished";
	}
	else {
		document.getElementById("status").innerHTML = host + ' ...';
		get_host( ['file',host,'monarch_home'], [addRow] )
	}
}

function addRow() {
	var args = arguments[0].split('|')
	var tbody = document.getElementById("reportTable").getElementsByTagName("TBODY")[0];
	var row = document.createElement("TR")
	var td1 = document.createElement("TD")
	td1.appendChild(document.createTextNode(args[0]))
	var td2 = document.createElement("TD")
	td2.appendChild(document.createTextNode(args[1]))
	var td3 = document.createElement("TD")
	td3.appendChild(document.createTextNode(args[2]))
	var td4 = document.createElement("TD")
	td4.appendChild(document.createTextNode(args[3]))
	var td5 = document.createElement("TD")
	td5.appendChild(document.createTextNode(args[4]))
	row.appendChild(td1);
	row.appendChild(td2);
	row.appendChild(td3);
	row.appendChild(td4);
	row.appendChild(td5);
	tbody.appendChild(row);
	scan_host()
}
</SCRIPT>
);

    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class valign=top width="25%">Scanning:</td>
<td class=$form_class><div id="status"></div>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
$javascript
$input_tags
<div class="scroll">
<table id="reportTable" width="100%" cellpadding=7 cellspacing=0 align=left border=0>
<tr>
<tbody>
</tbody>
</table>
</tr>
</table>
</div>
</td>
</tr>);

}

sub inheritance(@) {
    my $title    = $_[1];
    my $body     = $_[2];
    my $objects  = $_[3];
    my $tab      = $_[4];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my %objects  = %{$objects};
    my $detail   = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=wizard_title valign=top>$title</td>
</tr>
<tr>
<td class=wizard_body>
<table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
<tr>
<td class=wizard_body>
<input class=submitbutton type=submit name=select_all value="継承を設定" $tabindex>
</td>
<td class=wizard_body>$body</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub group_main(@) {
    my %group      = %{ $_[1] };
    my %docs       = %{ $_[2] };
    my @members    = @{ $_[3] };
    my @nonmembers = @{ $_[4] };
    my $tab        = $_[5];
    my $tabindex   = $tab ? "tabindex=\"$tab\"" : '';
    my %checked    = ();
    if ( $group{'status'} )    { $checked{'status'}    = 'checked' }
    if ( $group{'use_hosts'} ) { $checked{'use_hosts'} = 'checked' }

    if ( $group{'active_checks_enabled'} eq '1' ) {
	$checked{'active_checks_enabled'} = 'checked';
    }
    if ( $group{'passive_checks_enabled'} eq '1' ) {
	$checked{'passive_checks_enabled'} = 'checked';
    }
    if ( $group{'checks_enabled'} ) { $checked{'checks_enabled'} = 'checked' }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=wizard_title valign=top colspan=2>通知先グループ</td>
</tr>
<tr>
<td class=$form_class valign=top width="40%">$docs{'contactgroups'}</td>
</td>
<td class=$form_class>
<table cellspacing=0 align=left border=0>
<tr>
<td class=$form_class align=left>
<select name=contactgroups id=members size=10 multiple $tabindex>);
    @members = sort { lc($a) cmp lc($b) } @members;
    foreach my $mem (@members) {
	$detail .= "\n<option value=\"$mem\">$mem</option>";
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>
</td>
<td class=$form_class cellpadding=$global_cell_pad align=left>
<table cellspacing=0 cellpadding=3 align=center border=0>
<tr>
<td class=$form_class align=center>
<input class=submitbutton type=button value="削除 >>" onclick="delIt();" $tabindex>
</td>
</tr>
<tr>
<td class=$form_class align=center>
<input class=submitbutton type=button value="&nbsp;&nbsp;<< 追加&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" onclick="addIt();" $tabindex>
</td>
</tr>
</table>
</td>
<td class=$form_class align=left>
<select name=nonmembers id=nonmembers size=10 multiple $tabindex>);
    my $got_mem = undef;
    @nonmembers = sort { lc($a) cmp lc($b) } @nonmembers;
    foreach my $nmem (@nonmembers) {
	foreach my $mem (@members) {
	    if ( $nmem eq $mem ) { $got_mem = 1 }
	}
	if ($got_mem) {
	    $got_mem = undef;
	    next;
	}
	else {
	    $detail .= "\n<option value=\"$nmem\">$nmem</option>";
	}
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</select>
</td>
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>
<td class=data>
<table width="100%" cellpadding=3 cellspacing=0 align=left border=0>
<tr>
<td class=wizard_title valign=top colspan=2>グループステータス</td>
</tr>
<tr>
<td class=wizard_body colspan=2>$docs{'status'}
</td>
</tr>
<tr>
<td class=top_border width="25%">グループの非アクティブ設定:</td></td>
<td class=top_border>
<input class=row1 type=checkbox name=inactive value=1 $checked{'status'} $tabindex>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=3 cellspacing=0 align=left border=0>
<tr>
<td class=wizard_title valign=top colspan=3>インスタンス構築の設定</td>
</tr>
<tr>
<td class=wizard_body colspan=3>$docs{'build_instance_properties'}
<br>
</td>
</tr>
<tr>
<td class=top_border width="25%">構築フォルダ:</td>
<td class=top_border width="3%" align=center>
<a class=orange href='#doc' title=\"$docs{'location'}\" tabindex=-1>&nbsp;?&nbsp;</a>
</td>
<td class=top_border>
<input type=text size=75 name=location value="$group{'location'}" $tabindex>
</td>
</tr>
<tr>
<td class=top_border width="25%">Nagios etc フォルダ:</td>
<td class=top_border width="3%" align=center>
<a class=orange href='#doc' title=\"$docs{'nagios_etc'}\" tabindex=-1>&nbsp;?&nbsp;</a>
</td>
<td class=top_border>
<input type=text size=75 name=nagios_etc value="$group{'nagios_etc'}" $tabindex>
</td>
</tr>
<tr>
<td class=top_border width="25%">ホストの強制:</td></td>
<td class=top_border width="3%" align=center>
<a class=orange href='#doc' title=\"$docs{'use_hosts'}\" tabindex=-1>&nbsp;?&nbsp;</a>
</td>
<td class=top_border>
<input class=row1 type=checkbox name=use_hosts value=1 $checked{'use_hosts'} $tabindex>
</td>
</tr>
<tr>
<td class=top_border width="25%">強制チェック:</td></td>
<td class=top_border width="3%" align=center>
<a class=orange href='#doc' title=\"$docs{'checks_enabled'}\" tabindex=-1>&nbsp;?&nbsp;</a>
</td>
<td class=top_border>
<input class=row1 type=checkbox name=checks_enabled value=1 $checked{'checks_enabled'} $tabindex>
</td>
</tr>
<tr>
<td class=row1 width="25%" align=right>
<input class=row1 type=checkbox name=passive_checks_enabled value=1 $checked{'passive_checks_enabled'} $tabindex>
</td>
<td class=row1 colspan=2>パッシブチェック有効化</td>
</tr>
<tr>
<td class=row1 width="25%" align=right>
<input class=row1 type=checkbox name=active_checks_enabled value=1 $checked{'active_checks_enabled'} $tabindex>
</td>
<td class=row1 colspan=2>アクティブチェック有効化</td>
</tr>
</table>
</td>);
    return $detail;
}

sub group_hosts(@) {
    my $members              = $_[1];
    my $nonmembers           = $_[2];
    my $hostgroup_members    = $_[3];
    my $hostgroup_nonmembers = $_[4];
    my %members              = %{$members};
    my %nonmembers           = %{$nonmembers};
    my %hostgroup_members    = %{$hostgroup_members};
    my %hostgroup_nonmembers = %{$hostgroup_nonmembers};

    my $scroll_height = scalar (keys %members) + scalar (keys %hostgroup_members);
    $scroll_height = 10 if ($scroll_height < 10);
    $scroll_height = 20 if ($scroll_height > 20);
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<script language=JavaScript>
function doCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && (elements[i].name == 'rem_host_checked' || elements[i].name == 'rem_hostgroup_checked'))
           elements[i].checked = true;
    }
  }
}
function doUnCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && (elements[i].name == 'rem_host_checked' || elements[i].name == 'rem_hostgroup_checked'))
           elements[i].checked = false;
    }
  }
}
</script>

<tr>
<td width="100%" align=center>
<div class="scroll" style="height: ${scroll_height}em;" tabindex=-1>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    my $row = 1;

    foreach my $host ( sort { lc($a) cmp lc($b) } keys %members ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}

	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" valign=top width="3%">
<input type=checkbox name=rem_host_checked value="$host">
</td>
<td class="$class" align=left valign=top width="20%" colspan=2><b>$host</b></td>
<td class="$class" align=left valign=top width="10%">host &nbsp;</td>
<td class="$class" align=left valign=top width="70%">$members{$host}{'alias'} &nbsp;</td>
</tr>);
    }

    foreach my $hostgroup ( sort { lc($a) cmp lc($b) } keys %hostgroup_members ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}
	my $host_text = join ( ', ', @{ $hostgroup_members{$hostgroup} } );
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" valign=top width="3%">
<input type=checkbox name=rem_hostgroup_checked value="$hostgroup">
</td>
<td class="$class" align=left valign=top width="20%" colspan=2><b>$hostgroup</b></td>
<td class="$class" align=left valign=top width="10%">hostgroup &nbsp;</td>
<td class="$class" align=left valign=top width="70%">$host_text&nbsp;</td>
</tr>);
    }

    $scroll_height = scalar (keys %nonmembers);
    $scroll_height = 10 if ($scroll_height < 10);
    $scroll_height = 20 if ($scroll_height > 20);
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</div>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td><input class=submitbutton type=submit name=remove_host value="削除">&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェック" onclick=doCheckAll()>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェックを外す" onclick=doUnCheckAll()>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td width="100%" align=center>
<div class="scroll" style="height: ${scroll_height}em;" tabindex=-1>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    $row = 1;
    foreach my $host ( sort { lc($a) cmp lc($b) } keys %nonmembers ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}

	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" valign=top width="3%">
<input type=checkbox name=add_host_checked value="$host">
</td>
<td class="$class" align=left valign=top width="20%" colspan=2><b>$host</b></td>
<td class="$class" align=left valign=top width="77%">$nonmembers{$host}{'alias'}&nbsp;</td>
<td class="$class" align=left valign=top width="37%">$nonmembers{$host}{'address'}&nbsp;</td>
</tr>);
    }

    my $scroll_height = scalar (keys %hostgroup_nonmembers);
    $scroll_height = 10 if ($scroll_height < 10);
    $scroll_height = 20 if ($scroll_height > 20);
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</div>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td align=left width="20%">
<input class=submitbutton type=submit name=add_host value="ホストの追加">
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td width="100%" align=center>
<div class="scroll" style="height: ${scroll_height}em;" tabindex=-1>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    $row = 1;
    foreach my $hostgroup ( sort { lc($a) cmp lc($b) } keys %hostgroup_nonmembers ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}
	my $host_text = join ( ', ',  @{ $hostgroup_nonmembers{$hostgroup} } );
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" valign=top width="3%">
<input type=checkbox name=add_hostgroup_checked value="$hostgroup">
</td>
<td class="$class" align=left valign=top width="20%" colspan=2><b>$hostgroup</b></td>
<td class="$class" align=left valign=top width="77%">$host_text&nbsp;</td>
</tr>);
    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</div>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td align=left width="20%">
<input class=submitbutton type=submit name=add_hostgroup value="ホストグループの追加">
</td>
</tr>
</table>
</td>
</tr>);

    return $detail;
}

sub group_children(@) {
    my $group_hosts = $_[1];
    my $order       = $_[2];
    my $group_child = $_[3];
    my $nonmembers  = $_[4];
    my %group_hosts = %{$group_hosts};
    my @order       = @{$order};
    my %group_child = %{$group_child};
    my %nonmembers  = %{$nonmembers};
    my $detail      = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td width="100%" align=center>
<div class="scroll" style="height: 200px;">
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    my %child_parent = ();
    my $space        = undef;
    my $p_group      = 1;
    my $row          = 1;
    my $class        = undef;
    my %used         = ();

    foreach my $grp (@order) {
	my $childstr  = undef;
	my $childdesc = undef;
	delete $nonmembers{$grp};
	foreach my $child ( keys %{ $group_child{$grp} } ) {
	    $child_parent{$child} = $grp;
	    $childstr  .= "$child<br>";
	    $childdesc .= "$group_hosts{$child}{'description'}<br>";
	    $used{$child} = 1;
	    delete $nonmembers{$child};
	}
	if ( $child_parent{$grp} eq $p_group && $childstr ) {
	    $space = "&nbsp;";
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" width="3%">
&nbsp
<td class="$class\_top" valign=top>
$space<b>&bull;</b>&nbsp;$grp
</td>
<td class="$class\_top" valign=top>
&nbsp;
</td>
<td class="$class\_top" valign=top>
$childstr
</td>
<td class="$class\_top" valign=top>
$childdesc
</td>
</tr>);
	}
	else {
	    if ( $row == 1 ) {
		$class = 'row_lt';
		$row   = 2;
	    }
	    elsif ( $row == 2 ) {
		$class = 'row_dk';
		$row   = 1;
	    }
	    unless ( $used{$grp} ) {
		$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" width="3%" valign=top>
<input type=checkbox name=rem_group_checked value="$grp">
<td class="$class" colspan=1 valign=top>
$grp
</td>
<td class="$class" colspan=1 valign=top>
$group_hosts{$grp}{'description'}
</td>
<td class="$class" valign=top>
$childstr
</td>
<td class="$class" valign=top>
$childdesc
</td>
</tr>);
	    }
	    $space = undef;
	}
	$p_group = $grp;
    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</div>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td><input class=submitbutton type=submit name=remove_group value="削除"></td>
</tr>
</table>
</td>
</tr>
<tr>
<td width="100%" align=center>
<div class="scroll" style="height: 200px;">
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    $row = 1;
    foreach my $child ( sort { lc($a) cmp lc($b) } keys %nonmembers ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}

	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" width="3%">
<input type=checkbox name=add_group_checked value="$child">
</td>
<td class="$class" align=left valign=top width="20%" colspan=2><b>$child</b></td>
<td class="$class" align=left valign=top width="37%">$nonmembers{$child}{'description'}&nbsp;</td>
<td class="$class" align=left valign=top width="40%">$nonmembers{$child}{'hosts'}&nbsp;</td>
</tr>);

    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</div>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td align=left width="20%">
<input class=submitbutton type=submit name=add_group value="グループの追加">
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub group_macros(@) {
    my $macros        = $_[1];
    my $group_macros  = $_[2];
    my $label_enabled = $_[3];
    my $label         = $_[4];
    my %macros        = %{$macros};
    my %group_macros  = %{$group_macros};
    if ($label_enabled) { $label_enabled = 'checked' }
    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class width="3%">
<input type=checkbox name=label_enabled $label_enabled>
</td>
<td class=$form_class align=left width="10%">ラベルを有効化</td>
<td class=$form_class align=right width="10%">値:</td>
<td class=$form_class align=left width="77%"><input type=text name=label size=50 value="$label"></td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<div class="scroll" style="height: 200px;" tabindex=-1>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    my $row = 1;

    foreach my $macro ( sort { lc($a) cmp lc($b) } keys %group_macros ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" width="3%">
<input type=checkbox name=rem_macro_checked value="$macro">
</td>
<td class="$class" align=left width="20%"><b>$macro</b></td>
<td class="$class" align=left width="77%">$group_macros{$macro}{'description'}</td>
</tr>
<tr>
<td class="$class" width="3%">&nbsp;</td>
<td class="$class" align=left width="20%" valign=top>値:</td>
<td class="$class" align=left width="77%"><textarea rows=3 cols=70 name=value_$macro>$group_macros{$macro}{'value'}</textarea></td></tr>
</tr>);
    }

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</div>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td><input class=submitbutton type=submit name=set_values value="保存">&nbsp;&nbsp;
<input class=submitbutton type=submit name=remove_macro value="削除"></td>
</tr>
</table>
</td>
</tr>);

    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td width="100%" align=center>
<div class="scroll" style="height: 200px;" tabindex=-1>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    $row = 1;
    foreach my $macro ( sort { lc($a) cmp lc($b) } keys %macros ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}

	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" width="3%">
<input type=checkbox name=add_macro_checked value="$macro">
</td>
<td class="$class" align=left width="20%" colspan=2><b>$macro</b></td>
<td class="$class" align=left width="77%">$macros{$macro}{'description'}</td>
</tr>);

    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</div>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td align=left width="20%">
<input class=submitbutton type=submit name=add_macro value="マクロの追加">
</td>
</tr>
</table>
</td>
</tr>);
    return $detail;
}

sub macros(@) {
    my $macros   = $_[1];
    my $tab      = $_[2];
    my $tabindex = $tab ? "tabindex=\"$tab\"" : '';
    my %macros   = %{$macros};
    my $lasttab  = $tab + 1;

    my $detail = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td>
<div class="scroll" style="height: 400px;" tabindex=-1>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>);
    my $row = 1;
    foreach my $macro ( sort { lc($a) cmp lc($b) } keys %macros ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}

	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" width="3%"><input type=checkbox name=macro_checked value="$macro" $tabindex></td>
<td class="$class" align=left width="85%" colspan=2><b>$macro</b></td>
<td class="$class" align=left width="12%" rowspan=3><input class=submitbutton type=submit name=rename_$macro value="Rename" $tabindex></td>
</tr><tr>
<td class="$class" width="3%">&nbsp;</td>
<td class="$class" align=left width="10%">説明:</td>
<td class="$class" align=left width="75%"><input type=text size=70 name=description_$macro value="$macros{$macro}{'description'}" $tabindex></td>
</tr><tr>
<td class="$class" width="3%">&nbsp;</td>
<td class="$class" align=left width="10%" valign=top>値:</td>
<td class="$class" align=left width="75%"><textarea rows=3 cols=70 name=value_$macro $tabindex>$macros{$macro}{'value'}</textarea></td>
</tr>);

    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>

<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td class=$form_class align=left width="10%">&nbsp;</td>
<td class=$form_class align=left width="10%" colspan=2><b>新規マクロ</b></td>
<td class=$form_class align=center rowspan=4><input class=submitbutton type=submit name=add value="マクロ追加" tabindex=$lasttab></td>
</tr><tr>
<td class=$form_class align=left width="10%">マクロ&nbsp;名:&nbsp;</td>
<td class=$form_class align=left><input type=text size=50 name=name value="" $tabindex></td>
</tr><tr>
<td class=$form_class align=left width="10%">説明:</td>
<td class=$form_class align=left><input type=text size=70 name=description value="" $tabindex></td>
</tr><tr>
<td class=$form_class align=left width="10%" valign=top>値:</td>
<td class=$form_class align=left><textarea rows=3 cols=70 name=value value="" $tabindex></textarea></td>
</tr>
</table>
</td>
</tr>);

    return $detail;
}

sub main_cfg_misc(@) {
    my %misc_vals  = %{ $_[1] };
    my $misc_name  = $_[2];
    my $misc_value = $_[3];
    my $doc        = $_[4];
    my $tab        = $_[5];
    my $tabindex   = $tab ? "tabindex=\"$tab\"" : '';
    my $detail     = qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=data>
<table width="100%" cellpadding=$global_cell_pad cellspacing=0 align=left border=0>
<tr>
<td>
<table width="100%" cellspacing=0 align=left border=0>
<tr>
<td class=wizard_title colspan=4 valign=top colspan=3>その他の設定（オプション）</td>
</tr>
<tr>
<td class=wizard_body colspan=6>
<table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
<tr>
<td>
$doc
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=top_border width="100%" colspan=5>
<table width="100%" cellpadding=0 cellspacing=0 border=0>
<tr>
<td align="right">設定名：&nbsp;</td>

<td><input type=text size=20 name=misc_name value="" $tabindex></td>
<td align="right">&nbsp;&nbsp;&nbsp;値:&nbsp;</td>
<td><input type=text size=50 name=misc_value value="" $tabindex></td>
<td width="50%"></td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=top_border colspan=7 valign=top colspan=4>
<input class=submitbutton type=submit name=add_misc value="設定追加" $tabindex>
</td>
</tr>);

    if (%misc_vals) {
	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<script language=JavaScript>
function doCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'rem_key')
           elements[i].checked = true;
    }
  }
}
function doUnCheckAll()
{
  with (document.form) {
    for (var i=0; i < elements.length; i++) {
        if (elements[i].type == 'checkbox' && elements[i].name == 'rem_key')
           elements[i].checked = false;
    }
  }
}
</script>
<tr>
<td class=top_border valign=top width="3%">&nbsp</td>
<td class=top_border align=left valign=top width="20%"><b>名前</b></td>
<td class=top_border align=left valign=top width="77%"><b>値</b></td>
</tr>);
	my $row = 1;
	foreach my $key ( sort { $a <=> $b } keys %misc_vals ) {
	    my $class = undef;
	    if ( $row == 1 ) {
		$class = 'row_lt';
		$row   = 2;
	    }
	    elsif ( $row == 2 ) {
		$class = 'row_dk';
		$row   = 1;
	    }
	    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class="$class" valign=top width="3%">
<input type=checkbox name=rem_key value=$key $tabindex>
</td>
<td class="$class" align=left valign=top width="20%">$misc_vals{$key}{'name'}&nbsp;&nbsp;</td>
<td class="$class" align=left valign=top width="77%">
<input type=text size=70 name="$key" value="$misc_vals{$key}{'value'}" $tabindex>
</td>
</tr>);
	}

	$detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
<tr>
<td class=top_border colspan=5>
<input class=submitbutton type=submit name=rem_misc value="Remove Directive(s)" $tabindex>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェック" onclick=doCheckAll() $tabindex>&nbsp;&nbsp;
<input class=submitbutton type=button value="すべてチェックを外す" onclick=doUnCheckAll() $tabindex>
</td>
</tr>);
    }
    $detail .= qq(@{[&$Instrument::show_trace_as_html_comment()]}
</table>
</td>
</tr>);

    return $detail;
}

#
#############################
# Nagios 3 edit time period
#############################
#

sub time_period_detail(@) {
    my %time_period  = %{ $_[1] };
    my %time_periods = %{ $_[2] };
    my $tab          = $_[3];
    my $tabindex     = $tab ? "tabindex=\"$tab\"" : '';
    my $detail .= qq(
<tr>
<td class=data>
<table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
    <tr>
    <td class=row1><b>ウィークデイ</b></td>
    </tr>
    <td class=row1>
ウィークデイ設定（日曜から土曜）は一週間の内の適用する時間範囲をコンマで区分したリストです。 時間範囲を定義することができる７つの異なる曜日（日曜から土曜）の指定枠があります。 各々の時間範囲は <b>HH:MM-HH:MM</b> の形式で、24時クロック指定です。 たとえば <b>00:15-24:00</b> は、この日の早朝 00:15AM から、真夜中 12:00PM （総時間範囲 23 時間 45 分）を意味します。　時間帯から丸一日を除外したい場合は、時間帯定義を入力しなければよいだけです。
    </td>
    </tr>
    <tr>
    <td>
    <table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
        <tr>
        <td class=column_head align=left width=200px>名前</td>
        <td class=column_head align=left width=300px>時間</td>
        <td class=column_head align=left width=300px>説明</td>
        <td class=column_head align=right width=75px>&nbsp;</td>
        </tr>);
    my $row      = 1;
    my %got_day  = ();
    my @weekdays = ( 'sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday' );
    foreach my $day (@weekdays) {
	my $class = undef;

	if ( $time_period{'weekday'}{$day} ) {
	    $got_day{$day} = 1;
	    if ( $row == 1 ) {
		$class = 'row_lt';
		$row   = 2;
	    }
	    elsif ( $row == 2 ) {
		$class = 'row_dk';
		$row   = 1;
	    }
	    my $hours_style = '';
	    if ( exists $time_period{'weekday'}{$day}{'bad_hours'} ) {
		$hours_style = 'style="background-color: #FFFF99;"';
	    }
            my $day_jp;
            if ($day eq "sunday") { $day_jp = "日曜日" ;}
            if ($day eq "monday") { $day_jp = "月曜日" ;}
            if ($day eq "tuesday") { $day_jp = "火曜日" ;}
            if ($day eq "wednesday") { $day_jp = "水曜日" ;}
            if ($day eq "thursday") { $day_jp = "木曜日" ;}
            if ($day eq "friday") { $day_jp = "金曜日" ;}
            if ($day eq "saturday") { $day_jp = "土曜日" ;}

	    $detail .= qq(
        <tr>
        <td class="$class" valign=top><input type=hidden name=weekday_$day value=1>$day_jp</td>
        <td class="$class"><input $hours_style type=text size=40 name=value_$day value="$time_period{'weekday'}{$day}{'value'}" $tabindex></td>
        <td class="$class"><input type=text size=40 name=comment_$day value="$time_period{'weekday'}{$day}{'comment'}" $tabindex></td>
        <td class="$class" align=right valign=top><input type=submit class="$class" style="border:0;text-decoration:underline" name="remove_weekday_$day" value="削除" $tabindex></td>
        </tr>);
	}
    }
    unless ( keys %{ $time_period{'weekday'} } ) {
	$detail .= qq(
        <tr>
        <td class=row_lt colspan=4>None defined</td>
        </tr>);
    }
    $detail .= qq(
    </table>
    </td>
    </tr>
    <tr>
    <td>
    <table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
        <tr>
        <td class=data>
        <table width="100%" cellpadding=3 cellspacing=0 align=left border=0>
            <tr>
            <td class=row1 width=100px>
            <select name=new_day $tabindex>);
    my $options = undef;
    foreach my $day (@weekdays) {
	unless ( $got_day{$day} ) {
            my $day_jp;
            if ($day eq "sunday") { $day_jp = "日曜日" ;}
            if ($day eq "monday") { $day_jp = "月曜日" ;}
            if ($day eq "tuesday") { $day_jp = "火曜日" ;}
            if ($day eq "wednesday") { $day_jp = "水曜日" ;}
            if ($day eq "thursday") { $day_jp = "木曜日" ;}
            if ($day eq "friday") { $day_jp = "金曜日" ;}
            if ($day eq "saturday") { $day_jp = "土曜日" ;}
	    $options .= qq(<option value="$day">$day_jp</option>);
	}
    }
    unless ($options) {
	$options .= qq(<option name="no_days" value="">追加するものはありません</option>);
    }

    $detail .= qq(
$options
            </select tabindex=16>
            </td>
            <td class=row1 valign=top width=75px align=right><input class="submitbutton" type="submit" name="add_day" value="追加" $tabindex>
            <td class=row1>日を選択し、追加をクリックして時間を設定してください.</td>
            </td>
            </tr>
        </table>
        </td>
        </tr>
    </table>
    </td>
    </tr>
</table>
</td>
</tr>
    <tr>
    <td class=data>
    <table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
        <tr>
        <td class=row1><b>例外 (高度な設定)</b></td>
        </tr>
        <td class=row1>
    標準の週間スケジュールに対して、さまざまの異なるタイプの例外を指定することが出来ます。
            <br><br>
    例外は、通常や特定月の一日、ある月の特定の曜日やカレンダー上の一日など、複数の異なる形式を採ることができます。また、曜日や日付の範囲を指定したり、"これらの日付の間において３日毎に"というようなスキップ間隔指定の機能も実現できます。
            <br><br>
            指定例:
            <br><br>
            <table cellspacing=3 border=0>
            <tr><td style="padding-right:5px">2010-01-28</td><td>00:00-24:00</td><td>&mdash; January 28th, 2010</td></tr>
            <tr><td style="padding-right:5px">monday 3</td><td>00:00-24:00</td><td>&mdash; 3rd Monday of every month</td></tr>
            <tr><td style="padding-right:5px">day 2</td><td>00:00-24:00</td><td>&mdash; 2nd day of every month</td></tr>
            <tr><td style="padding-right:5px">february 10</td><td>00:00-24:00</td><td>&mdash; February 10th of every year</td></tr>
            <tr><td style="padding-right:5px">february -1</td><td>00:00-24:00</td><td>&mdash; Last day in February of every year</td></tr>
            <tr><td style="padding-right:5px">friday -2</td><td>00:00-24:00</td><td>&mdash; 2nd to last Friday of every month</td></tr>
            <tr><td style="padding-right:5px">thursday -1 november</td><td>00:00-24:00</td><td>&mdash; Last Thursday in November of every year</td></tr>
            </table>
            <br>
            より多くの例や何が行えるかについて、詳しくは <a href="http://nagios.sourceforge.net/docs/3_0/objectdefinitions.html#timeperiod" tabindex=-1>http://nagios.sourceforge.net/docs/3_0/objectdefinitions.html#timeperiod</a>
    　　　　を訪問してください.
            <br><br>
    ウィークデーとさまざまの例外は、すべて異なるレベルの優先度を持つため、それらが相互にどう影響するかを理解することが重要です.
            <br><br>優位性<br>
            <ol>
            <li>月中の特定日 (January 1st)</li>
            <li>一般的な月中の日付 (Day 15)</li>
            <li>特定月の曜日オフセット (2nd Tuesday in December)</li>
            <li>曜日オフセット (3rd Monday)</li>
            <li>曜日</li>
            </ol>
    これについてのより詳しいドキュメントは下記にあります：
    <a href="http://nagios.sourceforge.net/docs/3_0/timeperiods.html" tabindex=-1>http://nagios.sourceforge.net/docs/3_0/timeperiods.html</a> .
        </td>
        </tr>
        <tr>
        <td>
        <table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
        <tr>
        <td class=column_head align=left>デイルール</td>
        <td class=column_head align=left>時間</td>
        <td class=column_head align=left>説明</td>
        <td class=column_head align=right>&nbsp;</td>
        </tr>);
    $row = 1;
    foreach my $excp ( sort keys %{ $time_period{'exception'} } ) {
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}
	my $day_rule_style = '';
	if ( exists $time_period{'exception'}{$excp}{'bad_day_rule'} ) {
	    $day_rule_style = 'style="background-color: #FFFF99;"';
	}
	my $hours_style = '';
	if ( exists $time_period{'exception'}{$excp}{'bad_hours'} ) {
	    $hours_style = 'style="background-color: #FFFF99;"';
	}
	$detail .= qq(
        <tr>
        <td class="$class" valign=top><input $day_rule_style type=text size=40 name="exception_$excp" value="$excp" $tabindex></td>
        <td class="$class"><input $hours_style type=text size=35 name="value_$excp" value="$time_period{'exception'}{$excp}{'value'}" $tabindex></td>
        <td class="$class"><input type=text size=30 name="comment_$excp" value="$time_period{'exception'}{$excp}{'comment'}" $tabindex></td>
        <td class="$class" align=right valign=top><input type=submit class="$class" style="border:0;text-decoration:underline" name="remove_exception_$excp" value="remove" $tabindex></td>
        </tr>);
    }
    unless ( keys %{ $time_period{'exception'} } ) {
	$detail .= qq(
        <tr>
        <td class=row_lt colspan=4>定義されていません</td>
        </tr>);
    }
    $detail .= qq(
    </table>
    </td>
    </tr>
    <tr>
    <td>
    <table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
        <tr>
        <td class=data>
        <table width="100%" cellpadding=3 cellspacing=0 align=left border=0>
            <tr>
            <td class=row1>新規&nbsp;デイ&nbsp;ルール:&nbsp;</td>
	    <td class=row1 align=left><input type=text size=40 name=new_exception value="" $tabindex></td>
            <td class=row1 align=left></td>
            <td class=row1 align=left><input class="submitbutton" type="submit" name="add_exception" value="追加" $tabindex></td>
    <td class=row1 align=left width=50%>新しいデイルールを入力し、時間を設定するため「追加」をクリックしてください。</td>
            </tr>
        </table>
        </td>
        </tr>
    </table>
    </td>
    </tr>
</table>
</td>
</tr>
    <tr>
    <td class=data>
    <table width="100%" cellpadding=7 cellspacing=0 align=left border=0>
        <tr>
        <td class=row1><b>除外</b></td>
        </tr>
        <td class=row1>
この設定は上欄で指定された時間帯から除外されるべき時間帯を指定します。登録済みの時間帯定義を除外の定義に使用します。
        </td>
        </tr>
        <tr>
        <td>
        <table width="100%" cellpadding=5 cellspacing=0 align=left border=0>
            <tr>
            <td class=column_head align=right width=15px>&nbsp;</td>
            <td class=column_head align=left width=200px>時間帯名</td>
            <td class=column_head align=left width=300px>エイリアス</td>
            <td class=column_head align=left width=300px>説明</td>
            </tr>);
    $row = 1;
    foreach my $tname ( sort keys %time_periods ) {
	my $checked = undef;
	if ( $tname eq $time_period{'name'} ) { next }
	foreach my $id ( keys %{ $time_period{'exclude'} } ) {
	    $checked = 'checked' if $id eq $time_periods{$tname}{'id'};
	}
	my $class = undef;
	if ( $row == 1 ) {
	    $class = 'row_lt';
	    $row   = 2;
	}
	elsif ( $row == 2 ) {
	    $class = 'row_dk';
	    $row   = 1;
	}
	$detail .= qq(
            <tr>
            <td class="$class" align=right width=15px><input type="checkbox" name="exclude" value="$time_periods{$tname}{'id'}" $checked $tabindex></td>
            <td class="$class" align=left width=200px>$tname</td>
            <td class="$class" align=left width=300px>$time_periods{$tname}{'alias'}</td>
            <td class="$class" align=left width=300px>$time_periods{$tname}{'comment'}</td>
            </tr>);
    }
    unless ( keys %time_periods ) {
	$detail .= qq(<tr><td class=row_lt colspan=4>定義されていません</td></tr>);
    }
    $detail .= qq(
        </table>
        </td>
        </tr>
    </table>
    </td>
    </tr>
</table);

}

#
#############################
# NMS Integration
#############################
#

sub login_redirect() {
    return qq(
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>Monarch</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=utf-8">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<link rel="stylesheet" type="text/css" href="/monarch/monarch.css">
<link rel="StyleSheet" href="/monarch/dtree.css" type="text/css">
</head>
<body bgcolor="#f0f0f0" >
<!-- generated by: MonarchForms::login_redirect() -->
<table class=form width="75%" cellpadding=0 cellspacing=1 border=0>
<tr>
<td class=data>
<table width="100%" cellpadding=3 cellspacing=0 align=left border=0>
<tr>
<td class=head>Session Timeout</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class=data>
<table width="100%" cellpadding=3 cellspacing=0 align=left border=0>
<tr>
<td class=row1>Please <a href=$cgi_dir/monarch.cgi?view=logout target=_top>login</a>.</td>
</tr>
</table>
</td>
</tr>
</table>
</body>
<SCRIPT language=javascript1.1 type="text/javascript" src="/monarch/monarch.js"></SCRIPT>
<script src="/monarch/nicetitle.js" type="text/javascript"></script>
<script type="text/javascript" src="/monarch/DataFormValidator.js"></script>
</html>
);

}

sub login(@) {
    my $title   = $_[1];
    my $message = $_[2];
    if ($message) {
	$message = "&dagger;&nbsp;<b>$message</b><br><br>";
    }
    else {
	$message = undef;
    }
    return qq(
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<HTML>
<HEAD>
<title>Monarch</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=utf-8">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<link rel="stylesheet" type="text/css" href="/monarch/monarch.css">
<script type="text/javascript" src="/monarch/DataFormValidator.js"></script>
</HEAD>

<BODY bgcolor=#999999>
<!-- generated by: MonarchForms::login() -->
<table align=center width=800px cellspacing=0 cellpadding=0 border=0 bgcolor=#EEEEEE>
<tr>
<td><img src=/monarch/images/logo5.png border=0 align=left></td>
</tr>
<tr>
<td><img src=/monarch/images/home.jpg border=0></td>
</tr>
<tr>
<td>
<table align=center width=800px cellspacing=3 cellpadding=5 border=0 bgcolor=#EEEEEE>
<tr>
<td width=500px valign=top><br>
<h1>About GroundWork Monitor Architect</h1>
GroundWork Monitor Architect is a web based configuration tool for Nagios. Features in version 2.5 include:<ul>
<li>Multiple Nagios instance support</li>
<li>Improved navigation with Ajax</li>
<li>Multiple checks per service</li>
<li>Alternate EZ interface with Nmap Discovery</li>
</ul>
<h1>Support:</h1>Visit GroundWork's support forums at:
<a href="http://www.aemonitoropensource.com/community/forums/">www.aemonitoropensource.com/community/forums</a>
</td>
<td valign=top>
<form name=form action="$cgi_dir/monarch.cgi" method=post generator=login>
<table border="0" cellpadding="0" cellspacing="0">
<tr>
<td class="columnSpan01"><br><h1>ログインしてください</h1>
アカウントが無い場合は、管理者へご連絡ください。<br /><br />$message
</td>
</tr>
<tr>
<td>
<span class="formHeader">ユーザー名</span></td></tr>
<tr><td><input type="text" size="30" name="user_acct" value="" /></td>
</tr>
<tr>
<td><br><span class="formHeader">パスワード</span></td></tr>
<tr><td><input type="password" size="30" name="password" /></td>
<input type=hidden name=process_login value=1>
</tr>
<tr>
<td>
<br><input class="submitbutton" type="submit" value="ログイン" /></td>
</tr>
</table>
</form>
</td>
</tr>
</table>
</td>
</tr>

<table align=center width=800px cellspacing=0 cellpadding=0 border=0 bgcolor=#EEEEEE>
<tr>
<td>
<hr>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td>
<table align=center width=800px cellspacing=3 cellpadding=5 border=0 bgcolor=#EEEEEE>
<tr>
<td nowrap="nowrap" class="login_footer" valign="top">
<span class="login_footerHeader">GroundWork
	Open Source</span><br>
	139 Townsend Street, Suite 500<br>
	San Francisco, CA 94107 USA
</td>


<td nowrap="nowrap" class="login_footer" valign="top">
phone 415.992.4500<br>
fax 415.947.0684<br>
<a href="http://www.aemonitoropensource.com/">www.aemonitoropensource.com</a>
</td>

<td nowrap="nowrap" class="login_footer" valign="top">
2009 GroundWork<br>

Open Source<br>
All rights reserved.
</td>
<tr>
<td colspan=3>
&nbsp;
</td>
</tr>
</table>
</td>
</tr>
</table>
</BODY>
</HTML>);

}

sub unindent {
    $_[0] =~ s/^[\n\r]*//;
    my ($indent) = ( $_[0] =~ /^([ \t]+)/ );
    $_[0] =~ s/^$indent//gm;
}

1;

