#
# Update and Localize Nagios UI for GWMCE　v6.0
#        Ver 2.0        Date:2011.12.09
#                       Auther: Shinji Hirose
#       (c) Praesentia Corporation , Tokoyo Japan.

# Prerequisite packege check 
echo "環境を確認しています"

GCC=`yum list gcc |grep gcc |awk '{print $3}'`
if [ $GCC != "installed" ];then
  echo "Cコンパイラ（gcc）パッケージがありません"
  exit
fi

GDD=`yum list gd-devel |grep gd-devel |awk '{print $3}'`
if [ $GDD != "installed" ];then
  echo "gd 用の開発ライブラリ（gd-devel）パッケージがありません"
  exit
fi

# Checking prerequisite files
if [ ! -e nagios-3.1.0.tar.gz ];then
  echo "必要なファイルが存在しません：nagios-3.1.0.tar.gz"
  exit
fi

if [ ! -e nagios-3.1.0-ja-utf8.patch.gz ];then
  echo "必要なファイルが存在しません：nagios-3.1.0-ja-utf8.patch.gz"
  exit
fi

if [ ! -e sazanami-20040629.tar.bz2 ];then
  echo "必要なファイルが存在しません：sazanami-20040629.tar.bz2"
  exit
fi

if [ ! -e gng_nagios.diff ];then
  echo "必要なファイルが存在しません：gng_nagios.diff"
  exit
fi
echo "環境確認:OK"

# Stopping GWMCE
/usr/local/groundwork/ctlscript.sh stop

# Install Sazamani font
echo "フォントのインストール"
if [ ! -e /usr/local/groundwork/nagios/etc/font/font.ttf ] ; then

mkdir /usr/local/groundwork/nagios/etc/font
chown nagios.nagios /usr/local/groundwork/nagios/etc/font
chmod 755 /usr/local/groundwork/nagios/etc/font

tar jxf sazanami-20040629.tar.bz2
cp sazanami-20040629/sazanami-gothic.ttf /usr/local/groundwork/nagios/etc/font/font.ttf
rm -rf sazanami-20040629
fi

grep "ttf_file=/usr/local/nagios/etc/font/font.ttf" /usr/local/groundwork/nagios/etc/cgi.cfg >/dev/null 2>&1
if [ $? != 0 ];then
echo "ttf_file=/usr/local/nagios/etc/font/font.ttf" >> /usr/local/groundwork/nagios/etc/cgi.cfg
fi


# Patch and Compile Nagios
echo "Nagiosインストール開始"

BASEDIR=`pwd`

tar xzf nagios-3.1.0.tar.gz

cp -p nagios-3.1.0-ja-utf8.patch.gz nagios-3.1.0

cd nagios-3.1.0

gzip -dc nagios-3.1.0-ja-utf8.patch.gz| patch -p0

patch $BASEDIR/nagios-3.1.0/base/utils.c $BASEDIR/gng_nagios.diff

./configure --prefix=$BASEDIR/nagios-3.1.0/nagios --sbindir=$BASEDIR/nagios-3.1.0/nagios/sbin -with-nagios-user=nagios --with-nagios- group=nagios --with-command-user=nagios --with-command-group=nagios --enable-event-broker --with-file-perfdata  LDFLAGS=-L/usr/local/groundwork/common/lib

make clean
make all
make install

# Move Nagios Executable to GWMCE production environment

cp -p $BASEDIR/nagios-3.1.0/nagios/bin/nagiostats /usr/local/groundwork/nagios/bin/.nagiostats.bin
cp -p $BASEDIR/nagios-3.1.0/nagios/bin/nagios /usr/local/groundwork/nagios/bin/.nagios.bin
cp -pr $BASEDIR/nagios-3.1.0/nagios/sbin/*  /usr/local/groundwork/nagios/sbin

# delete working directry
cd $BASEDIR
rm -Rf $BASEDIR/nagios-3.1.0

# Starting GWMCE
echo "GWM 再起動"

/usr/local/groundwork/ctlscript.sh start
exit
